/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;

public class CoinPileBlock
extends FallingBlock {
    public static final MapCodec<CoinPileBlock> CODEC = CoinPileBlock.simpleCodec(CoinPileBlock::new);
    public static final BooleanProperty ISBASE = BooleanProperty.create((String)"isbase");
    public static final IntegerProperty HEAPS = IntegerProperty.create((String)"heaps", (int)1, (int)12);
    protected static final VoxelShape ONE_CUBE = CoinPileBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    protected static final VoxelShape TWO_CUBES = CoinPileBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0);
    protected static final VoxelShape THREE_CUBES = CoinPileBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    protected static final VoxelShape FOUR_CUBES = CoinPileBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
    protected static final VoxelShape FIVE_CUBES = CoinPileBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0);
    protected static final VoxelShape SIX_CUBES = CoinPileBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public CoinPileBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(ModSoundEvents.Types.COIN));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HEAPS, (Comparable)Integer.valueOf(1))).setValue((Property)ISBASE, (Comparable)Boolean.valueOf(true)));
    }

    public CoinPileBlock() {
        this(BlockBehaviour.Properties.of());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int heaps = (Integer)state.getValue((Property)HEAPS);
        if (heaps <= 1) {
            return ONE_CUBE;
        }
        if (heaps <= 3) {
            return TWO_CUBES;
        }
        if (heaps == 4) {
            return THREE_CUBES;
        }
        if (heaps == 5) {
            return FOUR_CUBES;
        }
        if (heaps <= 8) {
            return FIVE_CUBES;
        }
        return SIX_CUBES;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext UseContext) {
        return !UseContext.isSecondaryUseActive() && UseContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)HEAPS) < 12 || super.canBeReplaced(state, UseContext);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState clickedBlockState = context.getLevel().getBlockState(context.getClickedPos());
        if (clickedBlockState.is((Block)this) && (Integer)clickedBlockState.getValue((Property)HEAPS) < 12) {
            int currentHeaps = (Integer)clickedBlockState.getValue((Property)HEAPS);
            return (BlockState)clickedBlockState.setValue((Property)HEAPS, (Comparable)Integer.valueOf(currentHeaps + 1));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)ISBASE, (Comparable)Boolean.valueOf(!this.isCoinPileBlock(context.getLevel().getBlockState(context.getClickedPos().below()))));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState Below = level.getBlockState(pos.below());
        return this.isCoinPileBlock(Below) || !Below.isAir();
    }

    protected MapCodec<CoinPileBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState blockstate, LevelAccessor level, BlockPos CurrentPos, BlockPos facingPos) {
        level.scheduleTick(CurrentPos, (Block)this, this.getDelayAfterPlace());
        if (blockstate.isAir()) {
            return state;
        }
        if (facing == Direction.DOWN) {
            return (BlockState)state.setValue((Property)ISBASE, (Comparable)Boolean.valueOf(!this.isCoinPileBlock(blockstate)));
        }
        return state;
    }

    private boolean isCoinPileBlock(BlockState blockState) {
        return blockState.is((Block)this) || blockState.is(ModTags.Blocks.COINS);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HEAPS, ISBASE});
    }

    public void onLand(Level pLevel, BlockPos pPos, BlockState pState, BlockState pReplaceableState, FallingBlockEntity pFallingBlock) {
        pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)ISBASE, (Comparable)Boolean.valueOf(!this.isCoinPileBlock(pLevel.getBlockState(pPos.below())))));
    }
}

