/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.terraentity.init.TEEffects;

public class CorruptedOvariesBlock
extends Block {
    public CorruptedOvariesBlock() {
        super(BlockBehaviour.Properties.of().noCollission().pushReaction(PushReaction.DESTROY));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                return;
            }
            entity.makeStuckInBlock(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(level.isClientSide || entity.xOld == entity.getX() && entity.zOld == entity.getZ())) {
                double d0 = Math.abs(entity.getX() - entity.xOld);
                double d1 = Math.abs(entity.getZ() - entity.zOld);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    entity.hurt(level.damageSources().magic(), 3.0f);
                    if (living.getRandom().nextFloat() < 0.15f) {
                        living.addEffect(new MobEffectInstance((Holder)TEEffects.DEMONIC_THOUGHTS, 200));
                    }
                }
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.is(NatureBlocks.CORRUPT_GRASS_BLOCK) || stateBelow.is(NatureBlocks.CORRUPT_JUNGLE_GRASS_BLOCK);
    }
}

