/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.HorizontalDirectionalWithVerticalTwoPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.confluence.terraentity.entity.boss.QueenBee;
import org.confluence.terraentity.init.entity.TEBossEntities;

public class LarvaBlock
extends HorizontalDirectionalWithVerticalTwoPartBlock {
    protected static final VoxelShape SHAPE_UPPER = LarvaBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_LOWER = LarvaBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public LarvaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((StateProperties.VerticalTwoPart)state.getValue((Property)PART)).isBase()) {
            BlockPos below = pos.below();
            return level.getBlockState(below).isFaceSturdy((BlockGetter)level, below, Direction.UP);
        }
        BlockPos above = pos.above();
        return level.getBlockState(above).isFaceSturdy((BlockGetter)level, above, Direction.DOWN);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.scheduleTick(pos, (Block)this, 1);
        return state;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (((StateProperties.VerticalTwoPart)state.getValue((Property)PART)).isBase() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ModUtils.summonBoss(serverLevel, pos, (AbstractTerraBossBase)new QueenBee((EntityType)TEBossEntities.QUEEN_BEE.get(), level), false);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((StateProperties.VerticalTwoPart)state.getValue((Property)PART)).isBase() ? SHAPE_LOWER : SHAPE_UPPER;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollisionContext = (EntityCollisionContext)context;
            return entityCollisionContext.getEntity() instanceof Projectile ? Shapes.empty() : Shapes.block();
        }
        return Shapes.block();
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Projectile) {
            level.destroyBlock(pos, false);
        }
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        level.destroyBlock(hit.getBlockPos(), false);
    }
}

