/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.block.natural.BasePlantBlock;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.AccessoryItems;

public class NaturesGiftBlock
extends BasePlantBlock {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    protected final BlockItemType type;

    public NaturesGiftBlock(BlockItemType type) {
        super(Blocks.GRASS_BLOCK, Blocks.MOSS_BLOCK, Blocks.CLAY, (Block)NatureBlocks.JUNGLE_GRASS_BLOCK.get());
        this.type = type;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.type == BlockItemType.JUNGLE_ROSE ? new ItemStack((ItemLike)NatureBlocks.JUNGLE_ROSE.get()) : new ItemStack((ItemLike)AccessoryItems.NATURES_GIFT.get());
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter level, BlockPos pPos, CollisionContext pContext) {
        Vec3 vec3 = pState.getOffset(level, pPos);
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    private static ResourceKey<Block> createKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)id));
    }

    public static enum BlockItemType {
        JUNGLE_ROSE,
        NATURES_GIFT;

    }
}

