/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PalmLeaves
extends LeavesBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.SLAB_TYPE;
    protected static final VoxelShape BOTTOM_AABB = PalmLeaves.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = PalmLeaves.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public PalmLeaves(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)SlabType.BOTTOM));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED, TYPE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((SlabType)state.getValue(TYPE)) {
            case SlabType.DOUBLE -> Shapes.block();
            case SlabType.TOP -> TOP_AABB;
            default -> BOTTOM_AABB;
        };
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.scheduleTick(pos, (Block)this, 2);
        super.randomTick(state, level, pos, random);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, PalmLeaves.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(blockPos);
        BlockState ret = context.getLevel().getBlockState(blockPos);
        if (ret.is((Block)this)) {
            ret = (BlockState)((BlockState)ret.setValue(TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        } else {
            BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
            Direction direction = context.getClickedFace();
            ret = !(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)blockPos.getY() > 0.5) ? blockState : (BlockState)blockState.setValue(TYPE, (Comparable)SlabType.TOP);
        }
        return PalmLeaves.updateDistance((BlockState)ret.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.getItemInHand();
        SlabType slabtype = (SlabType)state.getValue(TYPE);
        if (slabtype == SlabType.DOUBLE || !itemstack.is(this.asItem())) {
            return false;
        }
        if (useContext.replacingClickedOnBlock()) {
            boolean flag = useContext.getClickLocation().y - (double)useContext.getClickedPos().getY() > 0.5;
            Direction direction = useContext.getClickedFace();
            return slabtype == SlabType.BOTTOM ? direction == Direction.UP || flag && direction.getAxis().isHorizontal() : direction == Direction.DOWN || !flag && direction.getAxis().isHorizontal();
        }
        return true;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return state.getValue(TYPE) != SlabType.DOUBLE && super.placeLiquid(level, pos, state, fluidState);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return state.getValue(TYPE) != SlabType.DOUBLE && super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return pathComputationType == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockPos;
        int i = 7;
        Iterator iterator = BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1)).iterator();
        while (iterator.hasNext() && (i = Math.min(i, PalmLeaves.getDistanceAt(level.getBlockState(blockPos = (BlockPos)iterator.next())) + 1)) != 1) {
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState neighbor) {
        return PalmLeaves.getOptionalDistanceAt((BlockState)neighbor).orElse(7);
    }
}

