/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.item.FoodItems;

public class ShimmerDroopingVinesBlock
extends CaveVinesBlock {
    public ShimmerDroopingVinesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    protected Block getBodyBlock() {
        return (Block)NatureBlocks.SHIMMER_DROOPING_VINE_PLANT.get();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return ShimmerDroopingVinesBlock.useShimmerBerries((Entity)player, state, level, pos);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FoodItems.SHIMMER_BERRIES.get());
    }

    public static InteractionResult useShimmerBerries(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        if (state.hasProperty((Property)BERRIES) && ((Boolean)state.getValue((Property)BERRIES)).booleanValue()) {
            ShimmerDroopingVinesBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FoodItems.SHIMMER_BERRIES.get(), 1));
            float f = Mth.randomBetween((RandomSource)level.random, (float)0.8f, (float)1.2f);
            level.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
            BlockState newState = (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)newState));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

