/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.block.natural.spreadable.SpreadingSandBlock;
import org.confluence.mod.common.block.natural.spreadable.extended.PearlsandBlock;
import org.confluence.mod.common.init.block.NatureBlocks;

public class SpreadableMoistenedSandBlock
extends Block
implements ISpreadable {
    private final ISpreadable.Type type;
    private final Supplier<? extends Block> targetBlock;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;

    public SpreadableMoistenedSandBlock(ISpreadable.Type type, BlockBehaviour.Properties properties, Supplier<? extends Block> targetBlock) {
        super(properties.randomTicks().instrument(NoteBlockInstrument.SNARE).strength(0.5f).sound(SoundType.SAND));
        this.type = type;
        this.targetBlock = targetBlock;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STILL_ALIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STILL_ALIVE, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Block block = this.targetBlock.get();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.below()).is(block)))).setValue((Property)UP, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.above()).is(block)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.north()).is(block)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.east()).is(block)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.south()).is(block)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(!blockgetter.getBlockState(blockpos.west()).is(block)));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!facingState.is(this.targetBlock.get())) {
            return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(false));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.UP)), (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get(rot.rotate(Direction.DOWN)), (Comparable)((Boolean)state.getValue((Property)DOWN)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.NORTH)), (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.SOUTH)), (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.EAST)), (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.WEST)), (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.UP)), (Comparable)((Boolean)state.getValue((Property)UP)))).setValue((Property)PROPERTY_BY_DIRECTION.get(mirror.mirror(Direction.DOWN)), (Comparable)((Boolean)state.getValue((Property)DOWN)));
    }

    @Override
    public ISpreadable.Type getSpreadType() {
        return this.type;
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!serverLevel.isAreaLoaded(blockPos, 3)) {
            return;
        }
        this.spread(blockState, serverLevel, blockPos, randomSource);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level.dimensionType().ultraWarm()) {
            if (state.is((Block)NatureBlocks.MOISTENED_EBONSAND_BLOCK.get())) {
                level.setBlock(pos, ((SpreadingSandBlock)NatureBlocks.EBONSAND.get()).defaultBlockState(), 3);
            } else if (state.is((Block)NatureBlocks.MOISTENED_CRIMSAND_BLOCK.get())) {
                level.setBlock(pos, ((SpreadingSandBlock)NatureBlocks.CRIMSAND.get()).defaultBlockState(), 3);
            } else if (state.is((Block)NatureBlocks.MOISTENED_PEARLSAND_BLOCK.get())) {
                level.setBlock(pos, ((PearlsandBlock)NatureBlocks.PEARLSAND.get()).defaultBlockState(), 3);
            }
            level.levelEvent(2009, pos, 0);
            level.playSound(null, pos, SoundEvents.WET_SPONGE_DRIES, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }
}

