/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThornBlock
extends PipeBlock {
    public static final MapCodec<ThornBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("damage_amount").forGetter(block -> Float.valueOf(block.damageAmount)), (App)Block.CODEC.fieldOf("ground_block").forGetter(block -> block.ground)).apply((Applicative)instance, ThornBlock::new));
    public static final IntegerProperty PROP_AGE = IntegerProperty.create((String)"age", (int)0, (int)7);
    protected final float damageAmount;
    protected final Block ground;

    public ThornBlock(float damageAmount, Block ground) {
        super(0.3125f, BlockBehaviour.Properties.of().replaceable().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY).randomTicks());
        this.damageAmount = damageAmount;
        this.ground = ground;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends PipeBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return this.getStateForPlacement((BlockGetter)pContext.getLevel(), pContext.getClickedPos());
    }

    public BlockState getStateForPlacement(BlockGetter pLevel, BlockPos pPos) {
        BlockState blockState = this.defaultBlockState();
        for (Direction direction : Direction.values()) {
            BlockState nearState = pLevel.getBlockState(pPos.relative(direction));
            blockState = (BlockState)blockState.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(nearState.is((Block)this) || nearState.is(this.ground)));
        }
        return blockState;
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pLevel.isClientSide()) {
            return;
        }
        if (pEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntity;
            player.hurt(ModDamageTypes.of(pLevel, (ResourceKey<DamageType>)DamageTypes.THORNS), this.damageAmount);
            pLevel.destroyBlock(pPos, false);
        }
        if (pEntity instanceof Projectile) {
            pLevel.destroyBlock(pPos, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, PROP_AGE});
        super.createBlockStateDefinition(pBuilder);
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return !pState.is((Block)NatureBlocks.PLANTERA_THORN.get()) && (Integer)pState.getValue((Property)PROP_AGE) < 7;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (this == NatureBlocks.PLANTERA_THORN.get() || pRandom.nextInt(50) != 0) {
            return;
        }
        Direction dir = Direction.getRandom((RandomSource)pRandom);
        BlockPos targetPos = pPos.relative(dir);
        if (!pLevel.getBlockState(targetPos).isAir() || this.checkBorder((Level)pLevel, targetPos, dir)) {
            return;
        }
        int age = (Integer)pState.getValue((Property)PROP_AGE);
        pLevel.setBlock(targetPos, (BlockState)this.getStateForPlacement((BlockGetter)pLevel, targetPos).setValue((Property)PROP_AGE, (Comparable)Integer.valueOf(Math.min(7, age + pRandom.nextInt(1, 3)))), 2);
        pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)PROPERTY_BY_DIRECTION.get(dir), (Comparable)Boolean.valueOf(true))).setValue((Property)PROP_AGE, (Comparable)Integer.valueOf(pRandom.nextBoolean() ? 7 : age + 1)), 2);
    }

    private boolean checkBorder(Level level, BlockPos pos, Direction direction) {
        for (Direction value : Direction.values()) {
            if (value == direction || value == direction.getOpposite() || !level.getBlockState(pos.relative(value)).is((Block)this)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return (BlockState)pState.setValue((Property)PROPERTY_BY_DIRECTION.get(pDirection), (Comparable)Boolean.valueOf(pNeighborState.is((Block)this) || pNeighborState.is(this.ground)));
    }
}

