/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.herbs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.particle.CrossDustParticleOptions;
import org.confluence.mod.common.block.natural.herbs.BaseHerbBlock;
import org.confluence.mod.common.init.item.FoodItems;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ShiveringThorn
extends BaseHerbBlock {
    public static final IntegerProperty PROP_LIGHT = IntegerProperty.create((String)"level", (int)0, (int)6);

    public ShiveringThorn() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).randomTicks().lightLevel(value -> (Integer)value.getValue((Property)AGE) == 2 ? (Integer)value.getValue((Property)PROP_LIGHT) : 0));
    }

    @Override
    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)FoodItems.SHIVERTHORN_SEED.get();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PROP_LIGHT});
    }

    @Override
    public boolean canBloom(ServerLevel level, BlockState state) {
        return this.getAge(state) == 2;
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.getAge(state) == 1) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)));
        }
        super.randomTick(state, level, pos, random);
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource random) {
        int brightness;
        if (this.getAge(state) != 2) {
            return;
        }
        int r = random.nextInt(200);
        if (r < 34) {
            Vector4f curve = new Vector4f(0.0f, 0.33f, 0.66f, 1.0f);
            Vec3 pos = blockPos.getCenter().add(state.getOffset((BlockGetter)level, blockPos)).offsetRandom(random, 0.5f);
            CrossDustParticleOptions particle = new CrossDustParticleOptions(false, -1, -1331036161, new Vector3f(), curve, 1.0f, 15, r < 17 ? 20 : -20, curve, true, true, false, true);
            level.addParticle((ParticleOptions)particle, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
        }
        if (r < 10) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(6)));
        } else if (r < 160 && (brightness = ((Integer)state.getValue((Property)PROP_LIGHT)).intValue()) > 0) {
            level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(brightness - 1)));
        }
    }
}

