/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable.conversion_table;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class ConversionTable {
    protected final Map<BlockState, BlockState> cache = new Object2ObjectOpenHashMap();
    protected boolean allowsAir = false;
    protected BlockState lastCheck;
    protected BlockState lastTarget;

    @Nullable
    public BlockState get(BlockState source, boolean hardmode) {
        if (!this.allowsAir && source.isAir()) {
            return null;
        }
        if (this.lastTarget != null && source == this.lastCheck) {
            return this.lastTarget;
        }
        BlockState computed = this.cache.computeIfAbsent(source, state -> this.getTargetState((BlockState)state, hardmode));
        if (source != this.lastCheck) {
            this.lastCheck = source;
            this.lastTarget = computed;
        }
        return computed;
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    @Nullable
    public BlockState get(BlockState source) {
        return this.get(source, true);
    }

    @ApiStatus.OverrideOnly
    @Nullable
    protected Block getTarget(BlockState source, boolean hardmode) {
        return this.getTarget(source);
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    @Nullable
    protected Block getTarget(BlockState source) {
        return null;
    }

    @Nullable
    protected <T extends Comparable<T>, V extends T> BlockState getTargetState(BlockState source, boolean hardmode) {
        Block target = this.getTarget(source, hardmode);
        if (target == null || source.is(target)) {
            return null;
        }
        BlockState targetState = target.defaultBlockState();
        for (Map.Entry entry1 : source.getValues().entrySet()) {
            if (!targetState.hasProperty((Property)entry1.getKey())) continue;
            targetState = (BlockState)targetState.setValue((Property)entry1.getKey(), (Comparable)entry1.getValue());
        }
        return targetState;
    }

    @Deprecated(forRemoval=true, since="1.2.0")
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    @Nullable
    protected <T extends Comparable<T>, V extends T> BlockState getTargetState(BlockState source) {
        return this.getTargetState(source, true);
    }

    public void clear() {
        this.cache.clear();
    }
}

