/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.palettes;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.block.palettes.ConnectedGlassBlock;

public class WindowBlock
extends ConnectedGlassBlock {
    protected final boolean translucent;

    public WindowBlock(BlockBehaviour.Properties properties, boolean translucent) {
        super(properties);
        this.translucent = translucent;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    @Override
    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (state.getBlock() == adjacentBlockState.getBlock()) {
            return true;
        }
        Block block = state.getBlock();
        if (block instanceof WindowBlock) {
            WindowBlock windowBlock = (WindowBlock)block;
            if (adjacentBlockState.getBlock() instanceof ConnectedGlassBlock) {
                return !windowBlock.isTranslucent() && side.getAxis().isHorizontal();
            }
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }
}

