/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.util.PlayerUtils;
import org.jetbrains.annotations.Nullable;

public record LootComponent(ResourceKey<LootTable> value) implements DataComponentType<LootComponent>
{
    public static final Codec<LootComponent> CODEC = ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).xmap(LootComponent::new, LootComponent::value);
    public static final StreamCodec<ByteBuf, LootComponent> STREAM_CODEC = ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE).map(LootComponent::new, LootComponent::value);

    public static boolean open(ServerPlayer serverPlayer, ItemStack itemStack) {
        LootComponent lootComponent = (LootComponent)itemStack.get(ModDataComponentTypes.LOOT);
        if (lootComponent != null) {
            float fishingPower = PlayerUtils.getFishingPower(serverPlayer);
            LootParams lootparams = new LootParams.Builder(serverPlayer.serverLevel()).withParameter(LootContextParams.ORIGIN, (Object)serverPlayer.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)serverPlayer).withLuck(fishingPower).create(LootContextParamSets.GIFT);
            LootTable loottable = serverPlayer.server.reloadableRegistries().getLootTable(lootComponent.value());
            for (ItemStack loot : loottable.getRandomItems(lootparams)) {
                if (serverPlayer.addItem(loot)) continue;
                serverPlayer.drop(loot, false, false);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public Codec<LootComponent> codec() {
        return CODEC;
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, LootComponent> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        block4: {
            block2: {
                block3: {
                    if (o == this) break block3;
                    if (!(o instanceof LootComponent)) break block2;
                    LootComponent lootComponent = (LootComponent)o;
                    try {
                        ResourceKey<LootTable> resourceKey;
                        ResourceKey<LootTable> value1 = resourceKey = lootComponent.value();
                        if (this.value != value1) break block2;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return 31 * this.value.registry().hashCode() + this.value.location().hashCode();
    }
}

