/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

public final class RepeaterContents
implements TooltipComponent {
    public static final RepeaterContents EMPTY = new RepeaterContents((List<ItemStack>)NonNullList.create(), 64);
    public static final Codec<RepeaterContents> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ItemStack.CODEC).fieldOf("items").forGetter(RepeaterContents::asItems), (App)Codec.INT.fieldOf("maxItemCapacity").forGetter(RepeaterContents::getMaxItemCapacity)).apply((Applicative)instance, RepeaterContents::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RepeaterContents> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, RepeaterContents::asItems, (StreamCodec)ByteBufCodecs.INT, RepeaterContents::getMaxItemCapacity, RepeaterContents::new);
    private final int maxItemCapacity;
    private final NonNullList<ItemStack> items;
    private final int hashCode;
    private final boolean isFull;
    private final int itemsTotalCount;
    private final int slotSize;
    private final boolean isEmpty;

    private RepeaterContents(List<ItemStack> stackList, int maxItemCapacity) {
        NonNullList items;
        if (stackList.isEmpty()) {
            items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack stack : stackList) {
                if (stack.isEmpty()) continue;
                list.add(stack);
            }
            int size = list.size();
            NonNullList nullList = NonNullList.withSize((int)(size + 1), (Object)ItemStack.EMPTY);
            for (int i = 0; i < size; ++i) {
                nullList.set(i, (Object)((ItemStack)list.get(i)).copy());
            }
            items = nullList;
        }
        this.items = items;
        this.maxItemCapacity = maxItemCapacity;
        this.itemsTotalCount = this.items.stream().filter(itemStack -> !itemStack.isEmpty()).mapToInt(ItemStack::getCount).sum();
        this.isEmpty = this.nonEmptyStream().toList().isEmpty();
        this.isFull = this.getItemsTotalCount() >= this.getMaxItemCapacity();
        this.slotSize = this.items.size();
        this.hashCode = ItemStack.hashStackList(this.items);
    }

    public static RepeaterContents fromItems(int capacity) {
        return new RepeaterContents((List<ItemStack>)NonNullList.createWithCapacity((int)1), capacity);
    }

    public static RepeaterContents fromItems(List<ItemStack> items, int capacity) {
        return new RepeaterContents(items, capacity);
    }

    private List<ItemStack> asItems() {
        return this.items.stream().filter(itemstack -> !itemstack.isEmpty()).collect(Collectors.toList());
    }

    public void copyInto(NonNullList<ItemStack> list) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            list.set(i, (Object)itemstack.copy());
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public int getItemsTotalCount() {
        return this.itemsTotalCount;
    }

    public int getMaxItemCapacity() {
        return this.maxItemCapacity;
    }

    public int getSlotSize() {
        return this.slotSize;
    }

    public int getUedSlotSize() {
        return this.nonEmptyStream().toList().size();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Stream<ItemStack> stream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Stream<ItemStack> nonEmptyStream() {
        return this.items.stream().filter(p_331322_ -> !p_331322_.isEmpty()).map(ItemStack::copy);
    }

    public Iterable<ItemStack> nonEmptyItems() {
        return Iterables.filter(this.items, p_331420_ -> !p_331420_.isEmpty());
    }

    public Iterable<ItemStack> nonEmptyItemsCopy() {
        return Iterables.transform(this.nonEmptyItems(), ItemStack::copy);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepeaterContents)) {
            return false;
        }
        RepeaterContents itemcontainercontents = (RepeaterContents)other;
        return ItemStack.listMatches(this.items, itemcontainercontents.items);
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((ItemStack)this.items.get(slot)).copy();
    }

    private void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlotSize()) {
            throw new UnsupportedOperationException("Slot " + slot + " not in valid range - [0," + this.getSlotSize() + ")");
        }
    }
}

