/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.component.prefix;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableListMultimap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.terra_curio.api.primitive.AttributeModifiersValue;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terraentity.init.TEAttributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface ModPrefix {
    public static final Map<String, Map<String, ? extends ModPrefix>> GROUPS = new HashMap<String, Map<String, ? extends ModPrefix>>();
    public static final HashBiMap<Integer, ModPrefix> ID_MAP = (HashBiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)1, (Object)Melee.LARGE);
        map.put((Object)2, (Object)Melee.MASSIVE);
        map.put((Object)3, (Object)Melee.DANGEROUS);
        map.put((Object)4, (Object)Melee.SAVAGE);
        map.put((Object)5, (Object)Melee.SHARP);
        map.put((Object)6, (Object)Melee.POINTY);
        map.put((Object)7, (Object)Melee.TINY);
        map.put((Object)8, (Object)Melee.TERRIBLE);
        map.put((Object)9, (Object)Melee.SMALL);
        map.put((Object)10, (Object)Melee.DULL);
        map.put((Object)11, (Object)Melee.UNHAPPY);
        map.put((Object)12, (Object)Melee.BULKY);
        map.put((Object)13, (Object)Melee.SHAMEFUL);
        map.put((Object)14, (Object)Melee.HEAVY);
        map.put((Object)15, (Object)Melee.LIGHT);
        map.put((Object)16, (Object)Ranged.SIGHTED);
        map.put((Object)17, (Object)Ranged.RAPID);
        map.put((Object)18, (Object)Ranged.HASTY);
        map.put((Object)19, (Object)Ranged.INTIMIDATING);
        map.put((Object)20, (Object)Ranged.DEADLY);
        map.put((Object)21, (Object)Ranged.STAUNCH);
        map.put((Object)22, (Object)Ranged.AWFUL);
        map.put((Object)23, (Object)Ranged.LETHARGIC);
        map.put((Object)24, (Object)Ranged.AWKWARD);
        map.put((Object)25, (Object)Ranged.POWERFUL);
        map.put((Object)26, (Object)Magic.MYTHIC);
        map.put((Object)27, (Object)Magic.ADEPT);
        map.put((Object)28, (Object)Magic.MASTERFUL);
        map.put((Object)29, (Object)Magic.INEPT);
        map.put((Object)30, (Object)Magic.IGNORANT);
        map.put((Object)31, (Object)Magic.DERANGED);
        map.put((Object)32, (Object)Magic.INTENSE);
        map.put((Object)33, (Object)Magic.TABOO);
        map.put((Object)34, (Object)Magic.CELESTIAL);
        map.put((Object)35, (Object)Magic.FURIOUS);
        map.put((Object)36, (Object)Universal.KEEN);
        map.put((Object)37, (Object)Universal.SUPERIOR);
        map.put((Object)38, (Object)Universal.FORCEFUL);
        map.put((Object)39, (Object)Universal.BROKEN);
        map.put((Object)40, (Object)Universal.DAMAGED);
        map.put((Object)41, (Object)Universal.SHODDY);
        map.put((Object)42, (Object)Common.QUICK);
        map.put((Object)43, (Object)Common.DEADLY);
        map.put((Object)44, (Object)Common.AGILE);
        map.put((Object)45, (Object)Common.NIMBLE);
        map.put((Object)46, (Object)Common.MURDEROUS);
        map.put((Object)47, (Object)Common.SLOW);
        map.put((Object)48, (Object)Common.SLUGGISH);
        map.put((Object)49, (Object)Common.LAZY);
        map.put((Object)50, (Object)Common.ANNOYING);
        map.put((Object)51, (Object)Common.NASTY);
        map.put((Object)52, (Object)Magic.MANIC);
        map.put((Object)53, (Object)Universal.HURTFUL);
        map.put((Object)54, (Object)Universal.STRONG);
        map.put((Object)55, (Object)Universal.UNPLEASANT);
        map.put((Object)56, (Object)Universal.WEAK);
        map.put((Object)57, (Object)Universal.RUTHLESS);
        map.put((Object)58, (Object)Ranged.FRENZYING);
        map.put((Object)59, (Object)Universal.GODLY);
        map.put((Object)60, (Object)Universal.DEMONIC);
        map.put((Object)61, (Object)Universal.ZEALOUS);
        map.put((Object)62, (Object)Accessory.HARD);
        map.put((Object)63, (Object)Accessory.GUARDING);
        map.put((Object)64, (Object)Accessory.ARMORED);
        map.put((Object)65, (Object)Accessory.WARDING);
        map.put((Object)66, (Object)Accessory.ARCANE);
        map.put((Object)67, (Object)Accessory.PRECISE);
        map.put((Object)68, (Object)Accessory.LUCKY);
        map.put((Object)69, (Object)Accessory.JAGGED);
        map.put((Object)70, (Object)Accessory.SPIKED);
        map.put((Object)71, (Object)Accessory.ANGRY);
        map.put((Object)72, (Object)Accessory.MENACING);
        map.put((Object)73, (Object)Accessory.BRISK);
        map.put((Object)74, (Object)Accessory.FLEETING);
        map.put((Object)75, (Object)Accessory.HASTY);
        map.put((Object)76, (Object)Accessory.QUICK);
        map.put((Object)77, (Object)Accessory.WILD);
        map.put((Object)78, (Object)Accessory.RASH);
        map.put((Object)79, (Object)Accessory.INTREPID);
        map.put((Object)80, (Object)Accessory.VIOLENT);
        map.put((Object)81, (Object)Melee.LEGENDARY);
        map.put((Object)82, (Object)Ranged.UNREAL);
        map.put((Object)83, (Object)Magic.MYTHICAL);
        map.put((Object)84, (Object)Melee.LEGENDARY2);
    });

    @Nullable
    default public PrefixComponent createComponent(PrefixType prefixType) {
        return null;
    }

    @Nullable
    default public PrefixComponent createComponent(PrefixType prefixType, ItemStack stack) {
        return this.createComponent(prefixType);
    }

    default public AttributeModifier createModifier(double value, AttributeModifier.Operation operation) {
        return new AttributeModifier(LibUtils.withUniqueSuffix((ResourceLocation)this.getModifierId()), value, operation);
    }

    public String name();

    public boolean canBeMercy();

    public ResourceLocation getModifierId();

    public static <T extends ModPrefix> Map<String, T> registerGroup(String name) {
        HashMap v = new HashMap();
        GROUPS.put(name, v);
        return v;
    }

    public static void initialize() {
        Accessory.init();
        Universal.init();
        Common.init();
        Melee.init();
        Ranged.init();
        Magic.init();
    }

    public record Accessory(String name, float armor, float criticalChance, float attackDamage, float attackSpeed, float movementSpeed, int additionalMana, int tier, float value) implements ModPrefix
    {
        public static final Map<String, Accessory> VALUES = ModPrefix.registerGroup("accessory");
        public static final ResourceLocation ID = Confluence.asResource("accessory_prefix");
        public static final Accessory HARD = Accessory.register("hard", 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 1, 0.1025f);
        public static final Accessory GUARDING = Accessory.register("guarding", 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 1, 0.21f);
        public static final Accessory ARMORED = Accessory.register("armored", 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 1, 0.3225f);
        public static final Accessory WARDING = Accessory.register("warding", 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0, 2, 0.44f);
        public static final Accessory PRECISE = Accessory.register("precise", 0.0f, 0.03f, 0.0f, 0.0f, 0.0f, 0, 1, 0.21f);
        public static final Accessory LUCKY = Accessory.register("lucky", 0.0f, 0.05f, 0.0f, 0.0f, 0.0f, 0, 2, 0.44f);
        public static final Accessory JAGGED = Accessory.register("jagged", 0.0f, 0.0f, 0.01f, 0.0f, 0.0f, 0, 1, 0.1025f);
        public static final Accessory SPIKED = Accessory.register("spiked", 0.0f, 0.0f, 0.02f, 0.0f, 0.0f, 0, 1, 0.21f);
        public static final Accessory ANGRY = Accessory.register("angry", 0.0f, 0.0f, 0.03f, 0.0f, 0.0f, 0, 1, 0.3225f);
        public static final Accessory MENACING = Accessory.register("menacing", 0.0f, 0.0f, 0.04f, 0.0f, 0.0f, 0, 2, 0.44f);
        public static final Accessory WILD = Accessory.register("wild", 0.0f, 0.0f, 0.0f, 0.01f, 0.0f, 0, 1, 0.1025f);
        public static final Accessory RASH = Accessory.register("rash", 0.0f, 0.0f, 0.0f, 0.02f, 0.0f, 0, 1, 0.21f);
        public static final Accessory INTREPID = Accessory.register("intrepid", 0.0f, 0.0f, 0.0f, 0.03f, 0.0f, 0, 1, 0.3225f);
        public static final Accessory VIOLENT = Accessory.register("violent", 0.0f, 0.0f, 0.0f, 0.04f, 0.0f, 0, 2, 0.44f);
        public static final Accessory BRISK = Accessory.register("brisk", 0.0f, 0.0f, 0.0f, 0.0f, 0.01f, 0, 1, 0.1025f);
        public static final Accessory FLEETING = Accessory.register("fleeting", 0.0f, 0.0f, 0.0f, 0.0f, 0.02f, 0, 1, 0.21f);
        public static final Accessory HASTY = Accessory.register("hasty", 0.0f, 0.0f, 0.0f, 0.0f, 0.03f, 0, 1, 0.3225f);
        public static final Accessory QUICK = Accessory.register("quick", 0.0f, 0.0f, 0.0f, 0.0f, 0.04f, 0, 2, 0.44f);
        public static final Accessory ARCANE = Accessory.register("arcane", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 20, 1, 0.3225f);

        @Override
        public PrefixComponent createComponent(PrefixType prefixType) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            if (this.armor != 0.0f) {
                builder.put((Object)Attributes.ARMOR, (Object)this.createModifier(this.armor, AttributeModifier.Operation.ADD_VALUE));
            }
            if (this.criticalChance != 0.0f) {
                builder.put((Object)TCAttributes.getCriticalChance(), (Object)this.createModifier(this.criticalChance, AttributeModifier.Operation.ADD_VALUE));
            }
            if (this.attackDamage != 0.0f) {
                builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).put((Object)TCAttributes.getRangedDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).put((Object)TCAttributes.getMagicDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).put((Object)TEAttributes.SUMMON_DAMAGE, (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.attackSpeed != 0.0f) {
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)this.createModifier(this.attackSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.movementSpeed != 0.0f) {
                builder.put((Object)Attributes.MOVEMENT_SPEED, (Object)this.createModifier(this.movementSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            return new PrefixComponent(prefixType, this.name, new AttributeModifiersValue(builder.build()), 0.0f, this.additionalMana, this.tier, this.value);
        }

        @Override
        public boolean canBeMercy() {
            return false;
        }

        @Override
        public ResourceLocation getModifierId() {
            return ID;
        }

        private static Accessory register(String name, float armor, float criticalChance, float attackDamage, float attackSpeed, float movementSpeed, int additionalMana, int tier, float value) {
            Accessory accessory = new Accessory(name, armor / 2.0f, criticalChance, attackDamage, attackSpeed, movementSpeed, additionalMana, tier, value);
            VALUES.put(name, accessory);
            return accessory;
        }

        private static void init() {
        }
    }

    public record Universal(String name, float attackDamage, float criticalChance, float knockBack, int tier, float value) implements ModPrefix
    {
        public static final Map<String, Universal> VALUES = ModPrefix.registerGroup("universal");
        public static final ResourceLocation ID = Confluence.asResource("universal_prefix");
        public static final Universal KEEN = Universal.register("keen", 0.0f, 0.03f, 0.0f, 1, 0.1236f);
        public static final Universal SUPERIOR = Universal.register("superior", 0.1f, 0.03f, 0.1f, 2, 0.6451f);
        public static final Universal FORCEFUL = Universal.register("forceful", 0.0f, 0.0f, 0.15f, 1, 0.3225f);
        public static final Universal BROKEN = Universal.register("broken", -0.3f, 0.0f, -0.2f, -2, -0.6864f);
        public static final Universal DAMAGED = Universal.register("damaged", -0.15f, 0.0f, 0.0f, -1, -0.2775f);
        public static final Universal SHODDY = Universal.register("shoddy", -0.1f, 0.0f, -0.15f, -2, -0.4148f);
        public static final Universal HURTFUL = Universal.register("hurtful", 0.1f, 0.0f, 0.0f, 1, 0.21f);
        public static final Universal STRONG = Universal.register("strong", 0.0f, 0.0f, 0.15f, 1, 0.21f);
        public static final Universal UNPLEASANT = Universal.register("unpleasant", 0.05f, 0.0f, 0.15f, 2, 0.4581f);
        public static final Universal WEAK = Universal.register("weak", 0.0f, 0.0f, -0.2f, -2, -0.36f);
        public static final Universal RUTHLESS = Universal.register("ruthless", 0.18f, 0.0f, -0.1f, 1, 0.1278f);
        public static final Universal GODLY = Universal.register("godly", 0.15f, 0.05f, 0.15f, 2, 1.1163f);
        public static final Universal DEMONIC = Universal.register("demonic", 0.15f, 0.05f, 0.0f, 2, 0.6002f);
        public static final Universal ZEALOUS = Universal.register("zealous", 0.0f, 0.05f, 0.0f, 1, 0.21f);

        @Override
        public PrefixComponent createComponent(PrefixType prefixType) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            if (this.attackDamage != 0.0f) {
                if (prefixType == PrefixType.UNIVERSAL || prefixType == PrefixType.MELEE) {
                    builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                } else if (prefixType == PrefixType.RANGED) {
                    builder.put((Object)TCAttributes.getRangedDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                } else if (prefixType == PrefixType.MAGIC) {
                    builder.put((Object)TCAttributes.getMagicDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            }
            if (this.criticalChance != 0.0f) {
                builder.put((Object)TCAttributes.getCriticalChance(), (Object)this.createModifier(this.criticalChance, AttributeModifier.Operation.ADD_VALUE));
            }
            if (this.knockBack != 0.0f) {
                builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)this.createModifier(this.knockBack, AttributeModifier.Operation.ADD_VALUE));
            }
            return new PrefixComponent(prefixType, this.name, new AttributeModifiersValue(builder.build()), 0.0f, 0, this.tier, this.value);
        }

        @Override
        public boolean canBeMercy() {
            return this.tier < 0;
        }

        @Override
        public ResourceLocation getModifierId() {
            return ID;
        }

        private static Universal register(String name, float attackDamage, float criticalChance, float knockBack, int tier, float value) {
            Universal universal = new Universal(name, attackDamage, criticalChance, knockBack, tier, value);
            VALUES.put(name, universal);
            return universal;
        }

        private static void init() {
        }
    }

    public record Common(String name, float attackDamage, float attackSpeed, float criticalChance, float knockBack, int tier, float value) implements ModPrefix
    {
        public static final Map<String, Common> VALUES = ModPrefix.registerGroup("common");
        public static final ResourceLocation ID = Confluence.asResource("common_prefix");
        public static final Common QUICK = Common.register("quick", 0.0f, 0.1f, 0.0f, 0.0f, 1, 0.21f);
        public static final Common DEADLY = Common.register("deadly", 0.1f, 0.1f, 0.0f, 0.0f, 2, 0.4641f);
        public static final Common AGILE = Common.register("agile", 0.0f, 0.1f, 0.03f, 0.0f, 1, 0.3596f);
        public static final Common NIMBLE = Common.register("nimble", 0.0f, 0.05f, 0.0f, 0.0f, 1, 0.1025f);
        public static final Common MURDEROUS = Common.register("murderous", 0.07f, 0.06f, 0.03f, 0.0f, 2, 0.4454f);
        public static final Common SLOW = Common.register("slow", 0.0f, -0.15f, 0.0f, 0.0f, -1, -0.2775f);
        public static final Common SLUGGISH = Common.register("sluggish", 0.0f, -0.2f, 0.0f, 0.0f, -2, -0.36f);
        public static final Common LAZY = Common.register("lazy", 0.0f, -0.08f, 0.0f, 0.0f, -1, -0.1536f);
        public static final Common ANNOYING = Common.register("annoying", -0.2f, -0.15f, 0.0f, 0.0f, -2, -0.5376f);
        public static final Common NASTY = Common.register("nasty", 0.05f, 0.1f, 0.02f, -0.1f, 1, 0.1687f);

        @Override
        public PrefixComponent createComponent(PrefixType prefixType) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            if (this.attackDamage != 0.0f) {
                if (prefixType == PrefixType.UNIVERSAL || prefixType == PrefixType.MELEE) {
                    builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                } else if (prefixType == PrefixType.RANGED) {
                    builder.put((Object)TCAttributes.getRangedDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                } else if (prefixType == PrefixType.MAGIC) {
                    builder.put((Object)TCAttributes.getMagicDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            }
            if (this.attackSpeed != 0.0f) {
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)this.createModifier(this.attackSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.criticalChance != 0.0f) {
                builder.put((Object)TCAttributes.getCriticalChance(), (Object)this.createModifier(this.criticalChance, AttributeModifier.Operation.ADD_VALUE));
            }
            if (this.knockBack != 0.0f) {
                builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)this.createModifier(this.knockBack, AttributeModifier.Operation.ADD_VALUE));
            }
            return new PrefixComponent(prefixType, this.name, new AttributeModifiersValue(builder.build()), 0.0f, 0, this.tier, this.value);
        }

        @Override
        public boolean canBeMercy() {
            return this.tier < 0 && this != ANNOYING;
        }

        @Override
        public ResourceLocation getModifierId() {
            return ID;
        }

        private static Common register(String name, float attackDamage, float attackSpeed, float criticalChance, float knockBack, int tier, float value) {
            Common common = new Common(name, attackDamage, attackSpeed, criticalChance, knockBack, tier, value);
            VALUES.put(name, common);
            return common;
        }

        private static void init() {
        }
    }

    public record Melee(String name, float attackDamage, float attackSpeed, float criticalChance, float size, float knockBack, int tier, float value) implements ModPrefix
    {
        public static final Map<String, Melee> VALUES = ModPrefix.registerGroup("melee");
        public static final ResourceLocation ID = Confluence.asResource("melee_prefix");
        public static final Melee LARGE = Melee.register("large", 0.0f, 0.0f, 0.0f, 0.12f, 0.0f, 1, 0.2544f);
        public static final Melee MASSIVE = Melee.register("massive", 0.0f, 0.0f, 0.0f, 0.18f, 0.0f, 1, 0.3924f);
        public static final Melee DANGEROUS = Melee.register("dangerous", 0.05f, 0.0f, 0.02f, 0.05f, 0.0f, 1, 0.3147f);
        public static final Melee SAVAGE = Melee.register("savage", 0.1f, 0.0f, 0.0f, 0.1f, 0.1f, 2, 0.7716f);
        public static final Melee SHARP = Melee.register("sharp", 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 1, 0.3225f);
        public static final Melee POINTY = Melee.register("pointy", 0.1f, 0.0f, 0.0f, 0.0f, 0.0f, 1, 0.21f);
        public static final Melee TINY = Melee.register("tiny", 0.0f, 0.0f, 0.0f, -0.18f, 0.0f, -1, -0.3276f);
        public static final Melee TERRIBLE = Melee.register("terrible", -0.15f, 0.0f, 0.0f, -0.13f, -0.15f, -2, -0.6049f);
        public static final Melee SMALL = Melee.register("small", 0.0f, 0.0f, 0.0f, -0.1f, 0.0f, -1, -0.19f);
        public static final Melee DULL = Melee.register("dull", -0.15f, 0.0f, 0.0f, 0.0f, 0.0f, -1, -0.2775f);
        public static final Melee UNHAPPY = Melee.register("unhappy", 0.0f, -0.1f, 0.0f, -0.1f, -0.1f, -2, -0.4686f);
        public static final Melee BULKY = Melee.register("bulky", 0.05f, -0.15f, 0.0f, 0.1f, 0.1f, 1, 0.1662f);
        public static final Melee SHAMEFUL = Melee.register("shameful", -0.1f, 0.0f, 0.0f, 0.1f, -0.2f, -2, -0.3727f);
        public static final Melee HEAVY = Melee.register("heavy", 0.0f, -0.1f, 0.0f, 0.0f, 0.15f, 0, 0.0712f);
        public static final Melee LIGHT = Melee.register("light", 0.0f, 0.15f, 0.0f, 0.0f, -0.1f, 0, 0.0712f);
        public static final Melee LEGENDARY = Melee.register("legendary", 0.15f, 0.1f, 0.05f, 0.1f, 0.15f, 2, 2.0985f);
        public static final Melee LEGENDARY2 = new Melee("legendary2", 0.17f, 0.0f, 0.08f, 0.0f, 0.17f, 2, 2.0985f);

        @Override
        public PrefixComponent createComponent(PrefixType prefixType) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            if (this.attackDamage != 0.0f) {
                builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.attackSpeed != 0.0f) {
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)this.createModifier(this.attackSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.criticalChance != 0.0f) {
                builder.put((Object)TCAttributes.getCriticalChance(), (Object)this.createModifier(this.criticalChance, AttributeModifier.Operation.ADD_VALUE));
            }
            if (this.size != 0.0f) {
                builder.put((Object)Attributes.ENTITY_INTERACTION_RANGE, (Object)this.createModifier(this.size, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.knockBack != 0.0f) {
                builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)this.createModifier(this.knockBack, AttributeModifier.Operation.ADD_VALUE));
            }
            return new PrefixComponent(prefixType, this.name, new AttributeModifiersValue(builder.build()), 0.0f, 0, this.tier, this.value);
        }

        @Override
        public boolean canBeMercy() {
            return this.tier < 0 && this != SHAMEFUL;
        }

        @Override
        public ResourceLocation getModifierId() {
            return ID;
        }

        private static Melee register(String name, float attackDamage, float attackSpeed, float criticalChance, float size, float knockBack, int tier, float value) {
            Melee melee = new Melee(name, attackDamage, attackSpeed, criticalChance, size, knockBack, tier, value);
            VALUES.put(name, melee);
            return melee;
        }

        private static void init() {
        }
    }

    public record Ranged(String name, float attackDamage, float attackSpeed, float criticalChance, float velocity, float knockBack, int tier, float value) implements ModPrefix
    {
        public static final Map<String, Ranged> VALUES = ModPrefix.registerGroup("ranged");
        public static final ResourceLocation ID = Confluence.asResource("ranged_prefix");
        public static final Ranged SIGHTED = Ranged.register("sighted", 0.1f, 0.0f, 0.03f, 0.0f, 0.0f, 1, 0.3596f);
        public static final Ranged RAPID = Ranged.register("rapid", 0.0f, 0.15f, 0.0f, 0.1f, 0.0f, 2, 0.6002f);
        public static final Ranged HASTY = Ranged.register("hasty", 0.0f, 0.1f, 0.0f, 0.15f, 0.0f, 2, 0.6002f);
        public static final Ranged INTIMIDATING = Ranged.register("intimidating", 0.0f, 0.0f, 0.0f, 0.05f, 0.15f, 2, 0.4581f);
        public static final Ranged DEADLY = Ranged.register("deadly", 0.1f, 0.05f, 0.02f, 0.05f, 0.05f, 2, 0.7538f);
        public static final Ranged STAUNCH = Ranged.register("staunch", 0.1f, 0.0f, 0.0f, 0.0f, 0.15f, 2, 0.6002f);
        public static final Ranged AWFUL = Ranged.register("awful", -0.15f, 0.0f, 0.0f, -0.1f, -0.1f, -2, -0.526f);
        public static final Ranged LETHARGIC = Ranged.register("lethargic", 0.0f, -0.15f, 0.0f, -0.1f, 0.0f, -2, -0.4148f);
        public static final Ranged AWKWARD = Ranged.register("awkward", 0.0f, -0.1f, 0.0f, 0.0f, -0.2f, -2, -0.4816f);
        public static final Ranged POWERFUL = Ranged.register("powerful", 0.15f, -0.1f, 0.01f, 0.0f, 0.0f, 1, 0.1145f);
        public static final Ranged FRENZYING = Ranged.register("frenzying", -0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0, -0.0445f);
        public static final Ranged UNREAL = Ranged.register("unreal", 0.15f, 0.1f, 0.05f, 0.1f, 0.15f, 2, 2.0985f);

        @Override
        public PrefixComponent createComponent(PrefixType prefixType) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            if (this.attackDamage != 0.0f) {
                builder.put((Object)TCAttributes.getRangedDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.attackSpeed != 0.0f) {
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)this.createModifier(this.attackSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.criticalChance != 0.0f) {
                builder.put((Object)TCAttributes.getCriticalChance(), (Object)this.createModifier(this.criticalChance, AttributeModifier.Operation.ADD_VALUE));
            }
            if (this.value != 0.0f) {
                builder.put((Object)TCAttributes.getRangedVelocity(), (Object)this.createModifier(this.velocity, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.knockBack != 0.0f) {
                builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)this.createModifier(this.knockBack, AttributeModifier.Operation.ADD_VALUE));
            }
            return new PrefixComponent(prefixType, this.name, new AttributeModifiersValue(builder.build()), 0.0f, 0, this.tier, this.value);
        }

        @Override
        public boolean canBeMercy() {
            return this.tier < 0 && this != FRENZYING;
        }

        @Override
        public ResourceLocation getModifierId() {
            return ID;
        }

        @Deprecated(since="1.2.0")
        @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
        public float rangedDamage() {
            return this.attackDamage;
        }

        private static Ranged register(String name, float rangedDamage, float attackSpeed, float criticalChance, float velocity, float knockBack, int tier, float value) {
            Ranged ranged = new Ranged(name, rangedDamage, attackSpeed, criticalChance, velocity, knockBack, tier, value);
            VALUES.put(name, ranged);
            return ranged;
        }

        private static void init() {
        }
    }

    public record Magic(String name, float attackDamage, float attackSpeed, float criticalChance, float manaCost, float knockBack, int tier, float value) implements ModPrefix
    {
        public static final Map<String, Magic> VALUES = ModPrefix.registerGroup("magic");
        public static final ResourceLocation ID = Confluence.asResource("magic_prefix");
        public static final Magic MYTHIC = Magic.register("mythic", 0.1f, 0.0f, 0.0f, -0.15f, 0.0f, 2, 0.6002f);
        public static final Magic ADEPT = Magic.register("adept", 0.0f, 0.0f, 0.0f, -0.15f, 0.0f, 1, 0.3225f);
        public static final Magic MASTERFUL = Magic.register("masterful", 0.15f, 0.0f, 0.0f, -0.15f, 0.05f, 2, 0.9263f);
        public static final Magic INEPT = Magic.register("inept", 0.0f, 0.0f, 0.0f, 0.1f, 0.0f, -1, -0.19f);
        public static final Magic IGNORANT = Magic.register("ignorant", -0.1f, 0.0f, 0.0f, 0.2f, 0.0f, -2, -0.4816f);
        public static final Magic DERANGED = Magic.register("deranged", -0.1f, 0.0f, 0.0f, 0.0f, -0.1f, -1, -0.3439f);
        public static final Magic INTENSE = Magic.register("intense", 0.1f, 0.0f, 0.0f, 0.15f, 0.0f, -1, -0.1258f);
        public static final Magic TABOO = Magic.register("taboo", 0.0f, 0.1f, 0.0f, 0.1f, 0.1f, 1, 0.1859f);
        public static final Magic CELESTIAL = Magic.register("celestial", 0.1f, -0.1f, 0.0f, -0.1f, 0.1f, 1, 0.1194f);
        public static final Magic FURIOUS = Magic.register("furious", 0.15f, 0.0f, 0.0f, 0.2f, 0.15f, 1, 0.1194f);
        public static final Magic MANIC = Magic.register("manic", -0.1f, 0.1f, 0.0f, -0.1f, 0.0f, 1, 0.1859f);
        public static final Magic MYTHICAL = Magic.register("mythical", 0.15f, 0.1f, 0.05f, -0.1f, 0.15f, 2, 2.0985f);

        @Override
        public PrefixComponent createComponent(PrefixType prefixType) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            if (this.attackDamage != 0.0f) {
                builder.put((Object)TCAttributes.getMagicDamage(), (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                builder.put((Object)TEAttributes.SUMMON_DAMAGE, (Object)this.createModifier(this.attackDamage, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.attackSpeed != 0.0f) {
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)this.createModifier(this.attackSpeed, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if (this.criticalChance != 0.0f) {
                builder.put((Object)TCAttributes.getCriticalChance(), (Object)this.createModifier(this.criticalChance, AttributeModifier.Operation.ADD_VALUE));
            }
            if (this.knockBack != 0.0f) {
                builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)this.createModifier(this.knockBack, AttributeModifier.Operation.ADD_VALUE));
            }
            return new PrefixComponent(prefixType, this.name, new AttributeModifiersValue(builder.build()), this.manaCost, 0, this.tier, this.value);
        }

        @Override
        public boolean canBeMercy() {
            return this.tier < 0 && this != INTENSE;
        }

        @Override
        public ResourceLocation getModifierId() {
            return ID;
        }

        @Deprecated(since="1.2.0")
        @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
        public float rangedDamage() {
            return this.attackDamage;
        }

        private static Magic register(String name, float rangedDamage, float attackSpeed, float criticalChance, float manaCost, float knockBack, int tier, float value) {
            Magic magic = new Magic(name, rangedDamage, attackSpeed, criticalChance, manaCost, knockBack, tier, value);
            VALUES.put(name, magic);
            return magic;
        }

        private static void init() {
        }
    }
}

