/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.component.prefix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.terra_curio.api.primitive.AttributeModifiersValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PrefixComponent(PrefixType type, String name, AttributeModifiersValue modifiers, float manaCost, int additionalMana, int tier, float value) implements DataComponentType<PrefixComponent>
{
    public static final Codec<PrefixComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PrefixType.CODEC.lenientOptionalFieldOf("type", (Object)PrefixType.UNKNOWN).forGetter(PrefixComponent::type), (App)Codec.STRING.lenientOptionalFieldOf("name", (Object)"unknown").forGetter(PrefixComponent::name), (App)AttributeModifiersValue.CODEC.lenientOptionalFieldOf("modifiers", (Object)AttributeModifiersValue.EMPTY).forGetter(PrefixComponent::modifiers), (App)Codec.FLOAT.lenientOptionalFieldOf("mana_cost", (Object)Float.valueOf(0.0f)).forGetter(PrefixComponent::manaCost), (App)Codec.INT.lenientOptionalFieldOf("additional_mana", (Object)0).forGetter(PrefixComponent::additionalMana), (App)Codec.INT.lenientOptionalFieldOf("tier", (Object)0).forGetter(PrefixComponent::tier), (App)Codec.FLOAT.lenientOptionalFieldOf("value", (Object)Float.valueOf(0.0f)).forGetter(PrefixComponent::value)).apply((Applicative)instance, PrefixComponent::new));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, PrefixComponent> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, PrefixComponent>(){

        @NotNull
        public PrefixComponent decode(@NotNull RegistryFriendlyByteBuf buffer) {
            PrefixType t1 = (PrefixType)((Object)PrefixType.STREAM_CODEC.decode((Object)buffer));
            String t2 = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            AttributeModifiersValue t3 = (AttributeModifiersValue)AttributeModifiersValue.STREAM_CODEC.decode((Object)buffer);
            float t4 = buffer.readFloat();
            int t5 = buffer.readInt();
            int t6 = buffer.readInt();
            float t7 = buffer.readFloat();
            return new PrefixComponent(t1, t2, t3, t4, t5, t6, t7);
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buffer, PrefixComponent component) {
            PrefixType.STREAM_CODEC.encode((Object)buffer, (Object)component.type);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)component.name);
            AttributeModifiersValue.STREAM_CODEC.encode((Object)buffer, (Object)component.modifiers);
            buffer.writeFloat(component.manaCost);
            buffer.writeInt(component.additionalMana);
            buffer.writeInt(component.tier);
            buffer.writeFloat(component.value);
        }
    };

    public MutableComponent getName() {
        return Component.translatable((String)("prefix.confluence." + this.name));
    }

    @Nullable
    public Codec<PrefixComponent> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<? super RegistryFriendlyByteBuf, PrefixComponent> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.modifiers.hashCode();
        result = 31 * result + Float.hashCode(this.manaCost);
        result = 31 * result + this.additionalMana;
        result = 31 * result + this.tier;
        result = 31 * result + Float.hashCode(this.value);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        float f;
        int n;
        float f2;
        PrefixType type1;
        Object object;
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrefixComponent)) return false;
        PrefixComponent prefixComponent = (PrefixComponent)o;
        try {
            object = prefixComponent.type();
            type1 = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object name1 = object = prefixComponent.name();
        Object modifiers1 = object = prefixComponent.modifiers();
        float cost = f2 = prefixComponent.manaCost();
        int mana = n = prefixComponent.additionalMana();
        int tier1 = n = prefixComponent.tier();
        float value1 = f = prefixComponent.value();
        if (mana != this.additionalMana) return false;
        if (tier1 != this.tier) return false;
        if (value1 != this.value) return false;
        if (cost != this.manaCost) return false;
        if (type1 != this.type) return false;
        if (!((String)name1).equals(this.name)) return false;
        if (!modifiers1.equals((Object)this.modifiers)) return false;
        return true;
    }
}

