/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.confluence.lib.common.data.SingleJsonFileReloadListener;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gui.AchievementToast;
import org.confluence.mod.common.data.AchievementOffset;

public class AchievementOffsetLoader
extends SingleJsonFileReloadListener {
    public static volatile CompletableFuture<Void> WAITING_FOR = CompletableFuture.completedFuture(null);
    private static AchievementOffsetLoader INSTANCE;
    private Map<ResourceLocation, AchievementOffset> registeredAchievements = ImmutableMap.of();

    public final CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        WAITING_FOR = super.reload(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
        return WAITING_FOR;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceList) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceList.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonElement json = entry.getValue();
            AchievementOffset.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(errorMsg -> Confluence.LOGGER.warn("Could not decode achievement offset with json id {} - error: {}", (Object)location, errorMsg)).ifPresent(offset -> builder.put((Object)location, offset));
        }
        this.registeredAchievements = builder.build();
    }

    protected ResourceLocation resourcePath() {
        return Confluence.asResource("achievement_offset.json");
    }

    protected String identifier() {
        return "Achievement Offset";
    }

    public Map<ResourceLocation, AchievementOffset> getRegisteredAchievements() {
        return this.registeredAchievements;
    }

    public static AchievementOffsetLoader getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AchievementOffsetLoader();
        }
        return INSTANCE;
    }

    public static void handle(Object2BooleanMap<ResourceLocation> value) {
        AchievementToast.clearToast();
        for (Object2BooleanMap.Entry entry : value.object2BooleanEntrySet()) {
            AchievementToast.registerToast((ResourceLocation)entry.getKey(), entry.getBooleanValue());
        }
    }

    public static Map<ResourceLocation, AchievementOffset> getDisplayOffset() {
        return AchievementOffsetLoader.getInstance().getRegisteredAchievements();
    }
}

