/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;

public class GameEventArgument
implements ArgumentType<GameEvent> {
    private static final SimpleCommandExceptionType UNKNOWN_KEY = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.confluence.arguments.game_event.unknown"));

    public GameEvent parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation id = ResourceLocation.read((StringReader)reader);
        Object event = GameEventSystem.INSTANCE.getEventInstance(GameEvent.createKey(id));
        if (event == null) {
            throw UNKNOWN_KEY.createWithContext((ImmutableStringReader)reader);
        }
        return event;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(this.stream(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return this.stream().toList();
    }

    private Stream<String> stream() {
        return GameEventSystem.INSTANCE.getEvents().keySet().stream().map(ResourceKey::location).map(ResourceLocation::toString);
    }
}

