/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.server.command.CommandUtils;
import org.confluence.mod.common.component.prefix.ModPrefix;

public record PrefixArgument(String group) implements ArgumentType<ModPrefix>
{
    private static final Dynamic2CommandExceptionType INVALID_PREFIX = new Dynamic2CommandExceptionType((found, constants) -> CommandUtils.makeTranslatableWithFallback((String)"commands.confluence.arguments.prefix.invalid", (Object[])new Object[]{constants, found}));

    public ModPrefix parse(StringReader reader) throws CommandSyntaxException {
        ModPrefix prefix;
        String name = reader.readUnquotedString();
        Map<String, ? extends ModPrefix> map = ModPrefix.GROUPS.get(this.group);
        if (map != null && (prefix = map.get(name)) != null) {
            return prefix;
        }
        throw INVALID_PREFIX.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)this.stream().toArray());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(this.stream(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return this.stream().toList();
    }

    private Stream<String> stream() {
        return ModPrefix.GROUPS.getOrDefault(this.group, Map.of()).keySet().stream();
    }

    public static class Info
    implements ArgumentTypeInfo<PrefixArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeUtf(template.group);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template(buffer.readUtf());
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("group", template.group);
        }

        public Template unpack(PrefixArgument argument) {
            return new Template(argument.group);
        }

        public class Template
        implements ArgumentTypeInfo.Template<PrefixArgument> {
            private final String group;

            Template(String group) {
                this.group = group;
            }

            public PrefixArgument instantiate(CommandBuildContext context) {
                return new PrefixArgument(this.group);
            }

            public ArgumentTypeInfo<PrefixArgument, ?> type() {
                return Info.this;
            }
        }
    }
}

