/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.fixer;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.confluence.lib.mixin.fixer.ChestBlockEntityAccessor;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.DeathChestBlock;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.data.fixer.FixedBaseChestBlock;
import org.confluence.mod.common.data.fixer.RegistriesFixer;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.VanityArmorItems;
import org.confluence.mod.common.item.armor.BaseVanityArmorItem;
import org.jetbrains.annotations.Nullable;

public class FixedDeathChestBlock
extends FixedBaseChestBlock
implements INetworkBlock {
    public FixedDeathChestBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TRAPPED_CHEST).explosionResistance(ModBlocks.getObsidianBasedExplosionResistance(0.0f)), RegistriesFixer.DEATH_CHEST_BLOCK_ENTITY::get);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    @Override
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof BEntity) {
            BEntity entity = (BEntity)object;
            return Collections.singletonList(FixedDeathChestBlock.setData(RegistriesFixer.DEATH_CHEST_BLOCK.toStack(), entity.variant));
        }
        return Collections.emptyList();
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return Mth.clamp((int)ChestBlockEntity.getOpenCount((BlockGetter)pBlockAccess, (BlockPos)pPos), (int)0, (int)15);
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pSide == Direction.UP ? pBlockState.getSignal(pBlockAccess, pPos, pSide) : 0;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        this.onNodeRemove(pState, pLevel, pPos, pNewState);
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.skipInteraction(player.getMainHandItem())) {
            return InteractionResult.PASS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            return FixedDeathChestBlock.setData(itemStack, entity.variant);
        }
        return itemStack;
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.execution(state, level, pos, color, true);
    }

    @Override
    public void onUnExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.execution(state, level, pos, color, false);
    }

    private void execution(BlockState pState, ServerLevel pLevel, BlockPos pPos, int pColor, boolean hasSignal) {
        INetworkEntity entity;
        Network network;
        BlockEntity blockEntity;
        if (pColor == -1) {
            return;
        }
        BlockPos relative = pPos.relative(FixedDeathChestBlock.getConnectedDirection((BlockState)pState));
        if (pState.getValue((Property)TYPE) != ChestType.SINGLE && (blockEntity = pLevel.getBlockEntity(relative)) instanceof INetworkEntity && (network = (entity = (INetworkEntity)blockEntity).getOrCreateNetworkNode().getNetwork(pColor)) != null && hasSignal != network.hasSignal()) {
            network.setSignal(hasSignal);
            network.getNodes().stream().map(NetworkNode::getEntity).collect(Collectors.toSet()).forEach(entity1 -> INetworkBlock.internalExecute(pLevel, relative, pColor, hasSignal, entity1));
        }
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : LibUtils.getTicker(blockEntityType, RegistriesFixer.DEATH_CHEST_BLOCK_ENTITY.get(), BEntity::deathTick);
    }

    public static ItemStack setData(ItemStack itemStack, FixedBaseChestBlock.Variant variant) {
        LibUtils.updateItemStackNbt((ItemStack)itemStack, tag -> tag.putInt("VariantId", variant.getId()));
        itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("block.confluence.base_chest_block." + variant.getSerializedName().replace("unlocked", "death"))).withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        return itemStack;
    }

    public static class BEntity
    extends FixedBaseChestBlock.BEntity
    implements INetworkEntity {
        private NetworkNode networkNode;
        private final Int2ObjectMap<Set<BlockPos>> connectedPoses = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<Set<BlockPos>> relativePoses = new Int2ObjectOpenHashMap();

        public BEntity(BlockPos pPos, BlockState pBlockState) {
            super(RegistriesFixer.DEATH_CHEST_BLOCK_ENTITY.get(), pPos, pBlockState);
        }

        protected void signalOpenCount(Level pLevel, BlockPos pPos, BlockState pState, int pEventId, int pEventParam) {
            super.signalOpenCount(pLevel, pPos, pState, pEventId, pEventParam);
            if (pEventId != pEventParam) {
                Block block = pState.getBlock();
                pLevel.updateNeighborsAt(pPos, block);
                pLevel.updateNeighborsAt(pPos.below(), block);
            }
        }

        public void unpackLootTable(@Nullable Player player) {
            if (this.getLootTable() != null) {
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    if (!((ItemStack)this.getItems().get(i)).isEmpty()) continue;
                    this.getItems().set(i, (Object)((BaseVanityArmorItem)((Object)VanityArmorItems.DEAD_MANS_SWEATER.get())).getDefaultInstance());
                    break;
                }
            }
            super.unpackLootTable(player);
        }

        public void startOpen(Player pPlayer) {
            super.startOpen(pPlayer);
            if (this.openersCounter.getOpenerCount() == 1) {
                ((INetworkBlock)this.getBlockState().getBlock()).execute(this.getBlockState(), (ServerLevel)this.getLevel(), this.getBlockPos(), true);
            }
        }

        public void stopOpen(Player pPlayer) {
            super.stopOpen(pPlayer);
            if (this.openersCounter.getOpenerCount() == 0) {
                ((INetworkBlock)this.getBlockState().getBlock()).execute(this.getBlockState(), (ServerLevel)this.getLevel(), this.getBlockPos(), false);
            }
        }

        public void onLoad() {
            super.onLoad();
            this.onNodeLoad();
        }

        public void onChunkUnloaded() {
            super.onChunkUnloaded();
            this.onNodeUnload();
        }

        @Override
        public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
            super.loadAdditional(tag, registryLookup);
            this.deserializePoses(tag, "connectedPoses", this.connectedPoses);
            this.deserializePoses(tag, "relativePoses", this.relativePoses);
        }

        @Override
        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            this.serializePoses(tag, "connectedPoses", this.connectedPoses);
            this.serializePoses(tag, "relativePoses", this.relativePoses);
        }

        @Override
        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            return this.serializePoses(super.getUpdateTag(registries), "connectedPoses", this.connectedPoses);
        }

        @Override
        public BlockEntity getSelf() {
            return this;
        }

        @Override
        public void setNetworkNode(NetworkNode node) {
            this.networkNode = node;
        }

        @Override
        @Nullable
        public NetworkNode getNetworkNode() {
            return this.networkNode;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getConnectedPoses() {
            return this.connectedPoses;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getRelativePoses() {
            return this.relativePoses;
        }

        @Override
        public void connectTo(int color, BlockPos relatedPos, INetworkEntity related) {
            if (this.getBlockState().getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE || !relatedPos.equals((Object)this.getBlockPos().relative(ChestBlock.getConnectedDirection((BlockState)this.getBlockState())))) {
                INetworkEntity.super.connectTo(color, relatedPos, related);
            }
        }

        public static void deathTick(Level level, BlockPos blockPos, BlockState blockState, BEntity entity) {
            ChestBlock target = entity.variant == FixedBaseChestBlock.Variant.UNLOCKED_GOLDEN ? (ChestBlock)ChestBlocks.DEATH_GOLDEN_CHEST.get() : (ChestBlock)ChestBlocks.DEATH_WOODEN_CHEST.get();
            ResourceKey lootTable = entity.lootTable;
            long lootTableSeed = entity.lootTableSeed;
            entity.setLootTable(null);
            NonNullList items = NonNullList.withSize((int)entity.getContainerSize(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < entity.getContainerSize(); ++i) {
                ItemStack itemStack = entity.getItem(i);
                if (itemStack.isEmpty()) continue;
                items.set(i, (Object)itemStack);
            }
            entity.clearContent();
            level.setBlockAndUpdate(blockPos, (BlockState)((BlockState)((BlockState)target.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)ChestBlock.FACING)))).setValue((Property)ChestBlock.WATERLOGGED, (Comparable)((Boolean)blockState.getValue((Property)ChestBlock.WATERLOGGED)))).setValue((Property)ChestBlock.TYPE, (Comparable)((ChestType)blockState.getValue((Property)ChestBlock.TYPE))));
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof DeathChestBlock.BEntity) {
                DeathChestBlock.BEntity blockEntity2 = (DeathChestBlock.BEntity)blockEntity;
                ((ChestBlockEntityAccessor)blockEntity2).callSetItems(items);
                blockEntity2.setLootTable(lootTable);
                blockEntity2.setLootTableSeed(lootTableSeed);
                blockEntity2.getConnectedPoses().putAll(entity.connectedPoses);
                blockEntity2.getRelativePoses().putAll(entity.relativePoses);
            }
        }
    }
}

