/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.confluence.mod.common.init.ModDataMaps;

public record BlockBreakSpawns(List<Spawn> spawns) {
    public static final Codec<BlockBreakSpawns> CODEC = Spawn.CODEC.listOf().xmap(BlockBreakSpawns::new, BlockBreakSpawns::spawns);

    public static void spawn(ServerLevel level, BlockPos pos, Holder<Block> holder) {
        BlockBreakSpawns data = (BlockBreakSpawns)holder.getData(ModDataMaps.BLOCK_BREAK_SPAWNS);
        if (data == null) {
            return;
        }
        Holder biome = level.getBiome(pos);
        for (Spawn spawn : data.spawns) {
            long count;
            if (spawn.maxAmount != 0x3F3F3F3F && (count = level.getEntities(null, new AABB(pos).inflate(7.5)).stream().filter(entity -> spawn.containsType(entity.getType())).count()) >= (long)spawn.maxAmount || spawn.biomes.size() > 0 && !spawn.biomes.contains(biome) || !(level.random.nextFloat() < spawn.chance)) continue;
            spawn.types.getRandomValue(level.random).ifPresent(type -> type.spawn(level, pos, MobSpawnType.MOB_SUMMONED));
        }
    }

    public static void spawn(ServerLevel level, BlockPos pos, BlockState state) {
        BlockBreakSpawns.spawn(level, pos, (Holder<Block>)state.getBlockHolder());
    }

    public static void spawn(ServerLevel level, BlockPos pos, Block block) {
        BlockBreakSpawns.spawn(level, pos, (Holder<Block>)block.builtInRegistryHolder());
    }

    public static class Spawn {
        public static final Codec<Spawn> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SimpleWeightedRandomList.wrappedCodec((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec()).fieldOf("types").forGetter(Spawn::types), (App)HolderSetCodec.create((ResourceKey)Registries.BIOME, (Codec)Biome.CODEC, (boolean)false).lenientOptionalFieldOf("biomes", (Object)HolderSet.empty()).forGetter(Spawn::biomes), (App)ExtraCodecs.POSITIVE_FLOAT.lenientOptionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(Spawn::chance), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("maxAmount", (Object)0x3F3F3F3F).forGetter(Spawn::maxAmount)).apply((Applicative)instance, Spawn::new));
        private final SimpleWeightedRandomList<EntityType<?>> types;
        private final HolderSet<Biome> biomes;
        private final float chance;
        private final int maxAmount;
        private transient Set<EntityType<?>> cachedTypes;

        public Spawn(SimpleWeightedRandomList<EntityType<?>> types, HolderSet<Biome> biomes, float chance, int maxAmount) {
            this.types = types;
            this.biomes = biomes;
            this.chance = chance;
            this.maxAmount = maxAmount;
        }

        public SimpleWeightedRandomList<EntityType<?>> types() {
            return this.types;
        }

        public HolderSet<Biome> biomes() {
            return this.biomes;
        }

        public float chance() {
            return this.chance;
        }

        public int maxAmount() {
            return this.maxAmount;
        }

        public boolean containsType(EntityType<?> type) {
            if (this.cachedTypes == null) {
                this.cachedTypes = this.types.unwrap().stream().map(WeightedEntry.Wrapper::data).collect(Collectors.toSet());
            }
            return this.cachedTypes.contains(type);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Spawn that = (Spawn)obj;
            return Objects.equals(this.types, that.types) && Objects.equals(this.biomes, that.biomes) && Float.floatToIntBits(this.chance) == Float.floatToIntBits(that.chance) && this.maxAmount == that.maxAmount;
        }

        public int hashCode() {
            return Objects.hash(this.types, this.biomes, Float.valueOf(this.chance), this.maxAmount);
        }

        public String toString() {
            return "Spawn[types=" + String.valueOf(this.types) + ", biomes=" + String.valueOf(this.biomes) + ", chance=" + this.chance + ", maxAmount=" + this.maxAmount + "]";
        }
    }
}

