/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.mojang.serialization.Codec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.mod.api.event.GetCustomDiggingPowerEvent;
import org.confluence.mod.common.init.ModDataMaps;
import org.confluence.mod.common.init.ModTiers;

public record DiggingPower(int power) {
    public static final Codec<DiggingPower> CODEC = ExtraCodecs.POSITIVE_INT.xmap(DiggingPower::new, DiggingPower::power);

    public static int getPower(ItemStack itemStack) {
        int power = -1;
        DiggingPower diggingPower = (DiggingPower)itemStack.getItemHolder().getData(ModDataMaps.DIGGING_POWER);
        if (diggingPower == null) {
            Item item = itemStack.getItem();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                Tier tier = tieredItem.getTier();
                if (tier instanceof ModTiers.PoweredTier) {
                    ModTiers.PoweredTier poweredTier = (ModTiers.PoweredTier)tier;
                    power = poweredTier.getPower();
                } else if (tier instanceof Tiers) {
                    Tiers tiers = (Tiers)tier;
                    power = ModTiers.getPowerForVanillaTiers(tiers);
                }
            }
        } else {
            power = diggingPower.power;
        }
        return ((GetCustomDiggingPowerEvent)NeoForge.EVENT_BUS.post((Event)new GetCustomDiggingPowerEvent(itemStack, power))).getPower();
    }
}

