/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import org.confluence.mod.api.event.bestiary.RegisterBestiaryKeyEvent;
import org.confluence.mod.common.data.saved.BestiaryEntry;
import org.confluence.mod.common.init.ModDataMaps;
import org.jetbrains.annotations.Nullable;

public record PresetBestiaryEntry(Either<BestiaryEntry, Map<String, BestiaryEntry>> either) {
    public static final Codec<PresetBestiaryEntry> CODEC = Codec.either(BestiaryEntry.CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, BestiaryEntry.CODEC)).xmap(PresetBestiaryEntry::new, PresetBestiaryEntry::either);

    public PresetBestiaryEntry(BestiaryEntry entry) {
        this((Either<BestiaryEntry, Map<String, BestiaryEntry>>)Either.left((Object)entry));
    }

    public PresetBestiaryEntry(Map<String, BestiaryEntry> map) {
        this((Either<BestiaryEntry, Map<String, BestiaryEntry>>)Either.right(map));
    }

    @Nullable
    public static BestiaryEntry getEntry(LivingEntity living) {
        PresetBestiaryEntry preset = ModDataMaps.getEntityData(ModDataMaps.BESTIARY_ENTRY, living.getType());
        if (preset == null) {
            return null;
        }
        String key = RegisterBestiaryKeyEvent.getKey(living);
        BestiaryEntry entry = (BestiaryEntry)preset.either.map(Function.identity(), map -> (BestiaryEntry)map.get(key));
        if (entry == null) {
            return null;
        }
        entry = entry.copy();
        entry.key = key;
        return entry;
    }
}

