/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.neoforged.fml.common.asm.enumextension.ExtensionInfo;
import net.neoforged.fml.common.asm.enumextension.IExtensibleEnum;
import net.neoforged.fml.common.asm.enumextension.NetworkedEnum;
import org.jetbrains.annotations.NotNull;

@NetworkedEnum(value=NetworkedEnum.NetworkCheck.BIDIRECTIONAL)
public enum GamePhase implements StringRepresentable,
IExtensibleEnum
{
    BEFORE_SKELETRON(0),
    AFTER_SKELETRON(100),
    WALL_OF_FLESH(200),
    MECHANICAL_BOSSES(300),
    PLANTERA(400),
    GOLEM(500),
    MOON_LORD(600);

    public static final Codec<GamePhase> CODEC;
    public static final IntFunction<GamePhase> BY_ORDER;
    public static final StreamCodec<ByteBuf, GamePhase> STREAM_CODEC;
    private final int order;

    private GamePhase(int order) {
        this.order = order;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isHardmode() {
        return this.isAtLeast(WALL_OF_FLESH);
    }

    public boolean isGraduated() {
        return this.isAtLeast(MOON_LORD);
    }

    public boolean isAboveThan(GamePhase other) {
        return this.getOrder() > other.getOrder();
    }

    public boolean isAtLeast(GamePhase other) {
        return this.getOrder() >= other.getOrder();
    }

    public int getOrder() {
        return this.order;
    }

    public static GamePhase getByOrder(int order) {
        return BY_ORDER.apply(order);
    }

    public static ExtensionInfo getExtensionInfo() {
        return ExtensionInfo.nonExtended(GamePhase.class);
    }

    static {
        CODEC = StringRepresentable.fromValues(GamePhase::values);
        BY_ORDER = ByIdMap.sparse(GamePhase::getOrder, (Object[])GamePhase.values(), (Object)((Object)AFTER_SKELETRON));
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ORDER, GamePhase::getOrder);
    }
}

