/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.booleans.BooleanObjectMutablePair;
import it.unimi.dsi.fastutil.booleans.BooleanObjectPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import org.confluence.lib.common.data.saved.IGlobalData;
import org.confluence.lib.util.LibCodecUtils;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.api.event.RegisterCloakDataEvent;
import org.confluence.mod.common.block.natural.ChlorophyteOreBlock;
import org.confluence.mod.common.block.natural.StepRevealingBlock;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.mod.network.s2c.GlobalCloakSyncPacketS2C;

public final class GlobalCloakData
implements IGlobalData {
    public static final GlobalCloakData INSTANCE = new GlobalCloakData();
    public static final Codec<Map<BlockState, BooleanObjectPair<BlockState>>> BLOCK_MAP_CODEC = LibCodecUtils.notStringKeyMap((String)"source", (Codec)BlockState.CODEC, (String)"pair", (Codec)LibCodecUtils.booleanObjectPair((String)"cloaked", (String)"target", (Codec)BlockState.CODEC));
    public static final Codec<Map<Item, BooleanObjectPair<Item>>> ITEM_MAP_CODEC = Codec.lazyInitialized(() -> {
        Codec codec = BuiltInRegistries.ITEM.byNameCodec();
        return LibCodecUtils.notStringKeyMap((String)"source", (Codec)codec, (String)"pair", (Codec)LibCodecUtils.booleanObjectPair((String)"cloaked", (String)"target", (Codec)codec));
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<BlockState, BooleanObjectPair<BlockState>>> BLOCK_MAP_STREAM_CODEC = ByteBufCodecs.map(HashMap::new, (StreamCodec)LibStreamCodecUtils.BLOCK_STATE, (StreamCodec)LibStreamCodecUtils.booleanObjectPair((StreamCodec)LibStreamCodecUtils.BLOCK_STATE));
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<Item, BooleanObjectPair<Item>>> ITEM_MAP_STREAM_CODEC = LibStreamCodecUtils.lazyInitialized(() -> {
        StreamCodec streamCodec = ByteBufCodecs.registry((ResourceKey)Registries.ITEM);
        return ByteBufCodecs.map(HashMap::new, (StreamCodec)streamCodec, (StreamCodec)LibStreamCodecUtils.booleanObjectPair((StreamCodec)streamCodec));
    });
    public static final int VERSION = 1;
    private Map<BlockState, BooleanObjectPair<BlockState>> blockMap = new IdentityHashMap<BlockState, BooleanObjectPair<BlockState>>();
    private Map<BlockState, BlockBehaviour.Properties> backupProperties = new IdentityHashMap<BlockState, BlockBehaviour.Properties>();
    private Map<Item, BooleanObjectPair<Item>> itemMap = new IdentityHashMap<Item, BooleanObjectPair<Item>>();
    private int version;

    private GlobalCloakData() {
    }

    public void fix(ServerLevel level) {
        if (this.version >= 1) {
            return;
        }
        this.version = 1;
        int revealStep = ConfluenceData.get(level).getRevealStep() + 1;
        if (revealStep == 0) {
            return;
        }
        ArrayList pairs = Lists.newArrayListWithExpectedSize((int)(revealStep + revealStep));
        for (int i = 0; i < revealStep; ++i) {
            BlockState[] pair = ((BlockState[][])StepRevealingBlock.PAIRS.get())[i];
            pairs.add(pair[0]);
            pairs.add(pair[1]);
        }
        INSTANCE.reveal(pairs.toArray(new BlockState[0]));
    }

    public void initialize() {
        BlockState deepslate = Blocks.DEEPSLATE.defaultBlockState();
        for (BlockState[] pair : (BlockState[][])StepRevealingBlock.PAIRS.get()) {
            this.fromBlock(pair[0], deepslate);
            this.fromBlock(pair[1], deepslate);
        }
        this.fromBlock(((ChlorophyteOreBlock)((Object)OreBlocks.CHLOROPHYTE_ORE.get())).defaultBlockState(), Blocks.MUD.defaultBlockState());
        ModLoader.postEvent((Event)new RegisterCloakDataEvent(this::fromBlock));
    }

    private void fromBlock(BlockState source, BlockState target) {
        this.blockMap.put(source, (BooleanObjectPair<BlockState>)new BooleanObjectMutablePair(true, (Object)target));
        this.backupProperties.put(source, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source.getBlock()));
        GlobalCloakData.replaceProperties(source, target);
        Item sourceItem = source.getBlock().asItem();
        Item targetItem = target.getBlock().asItem();
        if (sourceItem != Items.AIR && targetItem != Items.AIR) {
            this.itemMap.put(sourceItem, (BooleanObjectPair<Item>)new BooleanObjectMutablePair(true, (Object)targetItem));
        }
    }

    public void reveal(BlockState ... states) {
        for (BlockState state : states) {
            BooleanObjectPair<Item> pair1;
            BooleanObjectPair<BlockState> pair = this.blockMap.get(state);
            if (pair == null) continue;
            pair.left(false);
            GlobalCloakData.rollbackProperties(state, this.backupProperties.get(state));
            Item item = state.getBlock().asItem();
            if (item == Items.AIR || (pair1 = this.itemMap.get(item)) == null) continue;
            pair1.left(false);
        }
        GlobalCloakSyncPacketS2C.sendToAll();
    }

    public BlockState getTarget(BlockState source) {
        if (source.canBeReplaced()) {
            return source;
        }
        BooleanObjectPair<BlockState> pair = this.blockMap.get(source);
        if (pair == null || !pair.leftBoolean()) {
            return source;
        }
        return (BlockState)pair.right();
    }

    public Item getTarget(Item source) {
        BooleanObjectPair<Item> pair = this.itemMap.get(source);
        if (pair == null || !pair.leftBoolean()) {
            return source;
        }
        return (Item)pair.right();
    }

    public boolean isCloaked(BlockState source) {
        BooleanObjectPair<BlockState> pair = this.blockMap.get(source);
        return pair != null && pair.leftBoolean();
    }

    public boolean isRevealed(BlockState source) {
        return !this.isCloaked(source);
    }

    public boolean isCloaked(Item source) {
        BooleanObjectPair<Item> pair = this.itemMap.get(source);
        return pair != null && pair.leftBoolean();
    }

    public boolean isRevealed(Item source) {
        return !this.isCloaked(source);
    }

    public void decode(CompoundTag tag) {
        BLOCK_MAP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getList("BlockMap", 10)).ifSuccess(this.blockMap::putAll);
        ITEM_MAP_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.getList("ItemMap", 10)).ifSuccess(this.itemMap::putAll);
        this.version = tag.getInt("Version");
        this.rollbackAllProperties();
    }

    public void encode(CompoundTag tag) {
        BLOCK_MAP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.blockMap).ifSuccess(nbt -> tag.put("BlockMap", nbt));
        ITEM_MAP_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.itemMap).ifSuccess(nbt -> tag.put("ItemMap", nbt));
        tag.putInt("Version", this.version);
    }

    public void clear() {
        this.rollbackAllProperties();
        this.blockMap = new IdentityHashMap<BlockState, BooleanObjectPair<BlockState>>();
        this.backupProperties = new IdentityHashMap<BlockState, BlockBehaviour.Properties>();
        this.itemMap = new IdentityHashMap<Item, BooleanObjectPair<Item>>();
        this.version = 1;
        this.initialize();
    }

    public String serializeKey() {
        return "confluence:global_cloak_data";
    }

    public void networkEncode(RegistryFriendlyByteBuf buffer) {
        BLOCK_MAP_STREAM_CODEC.encode((Object)buffer, this.blockMap);
        ITEM_MAP_STREAM_CODEC.encode((Object)buffer, this.itemMap);
    }

    public void networkDecode(RegistryFriendlyByteBuf buffer) {
        this.blockMap = (Map)BLOCK_MAP_STREAM_CODEC.decode((Object)buffer);
        this.itemMap = (Map)ITEM_MAP_STREAM_CODEC.decode((Object)buffer);
    }

    public void rollbackAllProperties() {
        for (Map.Entry<BlockState, BooleanObjectPair<BlockState>> entry : this.blockMap.entrySet()) {
            if (entry.getValue().leftBoolean()) continue;
            GlobalCloakData.rollbackProperties(entry.getKey(), this.backupProperties.get(entry.getKey()));
        }
    }

    public static void replaceProperties(BlockState source, BlockState target) {
        Block sourceBlock = source.getBlock();
        Block targetBlock = target.getBlock();
        sourceBlock.hasCollision = targetBlock.hasCollision;
        sourceBlock.soundType = targetBlock.soundType;
        sourceBlock.friction = targetBlock.friction;
        sourceBlock.speedFactor = targetBlock.speedFactor;
        sourceBlock.jumpFactor = targetBlock.jumpFactor;
        sourceBlock.dynamicShape = targetBlock.dynamicShape;
        sourceBlock.requiredFeatures = targetBlock.requiredFeatures;
        sourceBlock.explosionResistance = targetBlock.explosionResistance;
        sourceBlock.properties = targetBlock.properties;
    }

    public static void rollbackProperties(BlockState source, BlockBehaviour.Properties properties) {
        Block sourceBlock = source.getBlock();
        sourceBlock.hasCollision = properties.hasCollision;
        sourceBlock.soundType = properties.soundType;
        sourceBlock.friction = properties.friction;
        sourceBlock.speedFactor = properties.speedFactor;
        sourceBlock.jumpFactor = properties.jumpFactor;
        sourceBlock.dynamicShape = properties.dynamicShape;
        sourceBlock.requiredFeatures = properties.requiredFeatures;
        sourceBlock.explosionResistance = properties.explosionResistance;
        sourceBlock.properties = properties;
    }
}

