/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.effect.harmful;

import java.util.Set;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.Tags;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModTags;

public class ManaSicknessEffect
extends MobEffect {
    public ManaSicknessEffect() {
        super(MobEffectCategory.HARMFUL, 255);
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        super.fillEffectCures(cures, effectInstance);
        cures.add(ModEffects.CANNOT_REMOVE_BY_NURSE);
    }

    public static float apply(DamageSource damageSource, float amount) {
        Player player;
        MobEffectInstance instance;
        float multiply = 1.0f;
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player && (instance = (player = (Player)entity).getEffect(ModEffects.MANA_SICKNESS)) != null && (damageSource.is(Tags.DamageTypes.IS_MAGIC) || player.getMainHandItem().is(ModTags.Items.MANA_WEAPON))) {
            int duration = instance.getDuration();
            multiply = duration == -1 ? 0.5f : (duration <= 100 ? 0.75f : 0.75f - 0.05f * (float)Math.round((float)(duration - 100) / 20.0f));
        }
        return amount * multiply;
    }
}

