/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.effect.harmful;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.mod.Confluence;
import org.confluence.mod.util.OverworldUtils;

public class WaterCandleEffect
extends MobEffect {
    public static final ResourceLocation WATER_CANDLE = Confluence.asResource("water_candle");

    public WaterCandleEffect() {
        super(MobEffectCategory.HARMFUL, 11064806);
        this.addAttributeModifier((Holder)ConfluenceMagicLib.MOB_SPAWN_SPEED_MULTIPLIER, WATER_CANDLE, AttributeModifier.Operation.ADD_VALUE, amplifier -> (double)(amplifier + 1) * 0.17);
        this.addAttributeModifier((Holder)ConfluenceMagicLib.MOB_SPAWN_COUNT_MULTIPLIER, WATER_CANDLE, AttributeModifier.Operation.ADD_VALUE, amplifier -> (double)(amplifier + 1) * 0.25);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        AttributeInstance instance = livingEntity.getAttributes().getInstance((Holder)ConfluenceMagicLib.MOB_SPAWN_SPEED_MULTIPLIER);
        if (instance != null) {
            double amount = (double)(amplifier + 1) * (livingEntity.getY() >= (double)OverworldUtils.getSpaceY() ? 0.8 : 0.17);
            AttributeModifier modifier = instance.getModifier(WATER_CANDLE);
            if (modifier == null || modifier.amount() != amount) {
                instance.addOrReplacePermanentModifier(new AttributeModifier(WATER_CANDLE, amount, AttributeModifier.Operation.ADD_VALUE));
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

