/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.common.CoinItem;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.data.molang.MolangExp;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class CoinPortalEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_AMOUNT = SynchedEntityData.defineId(CoinPortalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int age = 0;
    private int amount = 0;
    private ParticleEmitter emitter;

    public CoinPortalEntity(EntityType<CoinPortalEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        if (!pLevel.isClientSide) {
            this.amount = pLevel.random.nextInt(5, 16);
            this.entityData.set(DATA_AMOUNT, (Object)this.amount);
        }
    }

    public CoinPortalEntity(Level level, Vec3 position) {
        super((EntityType)ModEntities.COIN_PORTAL.get(), level);
        this.setNoGravity(true);
        this.setPos(position);
        this.setDeltaMovement(0.0, 0.5, 0.0);
        this.amount = level.random.nextInt(5, 16);
        this.entityData.set(DATA_AMOUNT, (Object)this.amount);
    }

    public void tick() {
        if (this.level().isClientSide && (this.emitter == null || this.emitter.isRemoved()) && this.amount != 0) {
            MolangExp expression = new MolangExp("variable.amount", (double)this.amount);
            this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("coin_portal"), expression);
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.96));
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide && this.age >= 20 && this.age % 10 == 0) {
            LibUtils.createItemEntity((ItemStack)((CoinItem)((Object)ModItems.GOLD_COIN.get())).getDefaultInstance(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (Level)this.level(), (int)0);
            if (--this.amount <= 0) {
                this.discard();
                return;
            }
        }
        ++this.age;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_AMOUNT, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (this.level().isClientSide && DATA_AMOUNT.equals(key)) {
            this.amount = (Integer)this.entityData.get(DATA_AMOUNT);
        }
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }
}

