/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.gameevent.MeteorShowerGameEvent;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.util.OverworldUtils;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class FallingStarItemEntity
extends ItemEntity {
    private static final EntityDataAccessor<Boolean> DATA_WAS_ON_GROUND = SynchedEntityData.defineId(FallingStarItemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private ParticleEmitter emitter;

    public FallingStarItemEntity(EntityType<FallingStarItemEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FallingStarItemEntity(Level level, Vec3 pos) {
        this((EntityType<FallingStarItemEntity>)((EntityType)ModEntities.FALLING_STAR_ITEM_ENTITY.get()), level);
        this.setPos(pos);
        this.setDeltaMovement(level.random.nextDouble(), -8.0, level.random.nextDouble());
        this.setItem(((Item)MaterialItems.FALLING_STAR.get()).getDefaultInstance());
        this.lifespan = 12000;
        this.setNeverPickUp();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_WAS_ON_GROUND, (Object)false);
    }

    public void tick() {
        if (this.level().isClientSide) {
            if (this.emitter == null || this.emitter.isRemoved()) {
                this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("falling_star"));
                this.emitter.attachEntity((Entity)this);
                PSGameClient.LOADER.addEmitter(this.emitter, false);
            }
            float y = Mth.sin((float)((float)this.getAge() / 10.0f + this.bobOffs)) * 0.1f;
            this.emitter.offsetPos = new Vec3(0.0, (double)(0.35f + y), 0.0);
        }
        super.tick();
        if (LibDateUtils.isDay((Level)this.level())) {
            this.onRemove();
            return;
        }
        if (this.onGround()) {
            if (this.hasPickUpDelay()) {
                this.setNoPickUpDelay();
            }
            if (!this.wasOnGround()) {
                this.setWasOnGround(true);
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSoundEvents.STAR_LANDS.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            }
        } else if (!this.wasOnGround() && !this.level().getBlockState(this.blockPosition().below(6)).isAir()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSoundEvents.STAR.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
        } else {
            HitResult hitResult;
            ServerLevel serverLevel;
            Level level = this.level();
            if (level instanceof ServerLevel && ModSecretSeeds.DONT_DIG_UP.match(serverLevel = (ServerLevel)level) && (hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, entity -> true)) instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                entityHitResult.getEntity().hurt(ModDamageTypes.of(this.level(), ModDamageTypes.FALLING_STAR), 100.0f);
                this.onRemove();
                return;
            }
        }
        if (!this.getInBlockState().isAir()) {
            this.setWasOnGround(true);
            this.setOnGround(true);
        }
    }

    private void onRemove() {
        this.discard();
        if (this.level().isClientSide && this.emitter != null) {
            this.emitter.remove();
        }
    }

    public void setWasOnGround(boolean was) {
        this.entityData.set(DATA_WAS_ON_GROUND, (Object)was);
    }

    public boolean wasOnGround() {
        return (Boolean)this.entityData.get(DATA_WAS_ON_GROUND);
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("wasOnGround", this.wasOnGround());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setWasOnGround(pCompound.getBoolean("wasOnGround"));
    }

    public static void summon(ServerLevel level) {
        if (((Boolean)CommonConfigs.DO_FALLING_STAR_SPAWNING.get()).booleanValue() && LibDateUtils.isNight((Level)level) && level.getGameTime() % (long)FallingStarItemEntity.getFallingStarSpawnInterval(level) == 0L) {
            HashSet<Vec3> cache = new HashSet<Vec3>();
            for (ServerPlayer player : level.players()) {
                if (player.level().dimension() != OverworldUtils.dimension() || cache.stream().anyMatch(pos -> player.distanceToSqr(pos) < (double)Mth.square((int)(player.requestedViewDistance() * 16)))) continue;
                int offsetX = Mth.nextInt((RandomSource)level.random, (int)-16, (int)16);
                int offsetZ = Mth.nextInt((RandomSource)level.random, (int)-16, (int)16);
                BlockPos pos2 = player.blockPosition().offset(offsetX, 0, offsetZ).atY(256);
                if (!level.isLoaded(pos2)) continue;
                level.addFreshEntity((Entity)new FallingStarItemEntity((Level)level, pos2.getCenter()));
                cache.add(player.position());
            }
        }
    }

    private static int getFallingStarSpawnInterval(ServerLevel level) {
        int interval = (Integer)CommonConfigs.FALLING_STAR_INTERVAL.get();
        if (MeteorShowerGameEvent.INSTANCE.started()) {
            float factor = ((Double)CommonConfigs.METEOR_SHOWER_EVENT_FALLING_STAR_SPAWN_SPEED_MULTIPLIER.get()).floatValue();
            return LibUtils.divideInt((int)interval, (float)factor, (RandomSource)level.random);
        }
        return interval;
    }
}

