/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.minecart;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.util.AchievementUtils;
import org.jetbrains.annotations.Nullable;

public class BaseMinecartEntity
extends Minecart {
    public static final double MECHANICAL_CART_MAX_SPEED = 1.23;
    public static final double MECHANICAL_CART_ACCELERATION = 2.5;
    public static final double MECHANICAL_CART_DRAG_AIR = 0.99;
    protected ResourceLocation dropItem = ResourceLocation.withDefaultNamespace((String)"air");
    protected float maxSpeed = 0.0f;
    protected double acceleration = 0.0;
    @Nullable
    protected LivingEntity driver;

    public BaseMinecartEntity(EntityType<? extends BaseMinecartEntity> entityType, Level level) {
        super(entityType, level);
    }

    public BaseMinecartEntity(Level level, double x, double y, double z, Abilities<? extends BaseMinecartEntity> abilities) {
        super(abilities.entityType.get(), level);
        this.dropItem = abilities.dropItem;
        this.acceleration = abilities.acceleration;
        this.setCurrentCartSpeedCapOnRail(abilities.maxSpeed);
        this.setDragAir(abilities.dragAir);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            boolean bz;
            LivingEntity living;
            Entity entity2 = this.getFirstPassenger();
            this.driver = entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null;
            Vec3 movement = this.getDeltaMovement();
            boolean bx = Math.abs(movement.x) > 0.1;
            boolean bl = bz = Math.abs(movement.z) > 0.1;
            if (bx || bz) {
                double sx = bx ? movement.x : 0.0;
                double sz = bz ? movement.z : 0.0;
                AABB aabb = this.getBoundingBox().move(sx, 0.0, sz).inflate(Math.abs(sx), 0.0, Math.abs(sz));
                List list = this.level().getEntities((Entity)this, aabb, entity -> !this.hasPassenger((Entity)entity) && EntitySelector.pushableBy((Entity)this).test(entity));
                if (!list.isEmpty()) {
                    LivingEntity livingEntity;
                    boolean killed = false;
                    for (Entity entity3 : list) {
                        double distance = movement.horizontalDistance();
                        entity3.hurt(this.damageSources().flyIntoWall(), (float)distance * 5.0f);
                        VectorUtils.knockBackA2B((Entity)this, (Entity)entity3, (double)(distance * 0.5), (double)0.2);
                        if (entity3.isAlive()) continue;
                        killed = true;
                    }
                    if (killed && (livingEntity = this.driver) instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        AchievementUtils.awardAchievement(serverPlayer, "vehicular_manslaughter");
                    }
                }
            }
        }
    }

    public boolean isPushable() {
        return this.driver == null;
    }

    public void setDeltaMovement(Vec3 deltaMovement) {
        if (!this.horizontalCollision || this.shouldPerformStop()) {
            super.setDeltaMovement(deltaMovement);
        }
    }

    private boolean shouldPerformStop() {
        if (this.isOnRails()) {
            BlockPos pos = this.getCurrentRailPosition();
            BlockState state = this.level().getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock block2 = (BaseRailBlock)block;
                return !block2.getRailDirection(state, (BlockGetter)this.level(), pos, (AbstractMinecart)this).isAscending();
            }
        }
        return true;
    }

    public void moveMinecartOnRail(BlockPos pos) {
        double d25;
        boolean upgradeKit;
        boolean bl = upgradeKit = this.driver != null && EverBeneficial.of(this.driver).isMinecartUpgradeKitUsed();
        if (upgradeKit) {
            this.setDragAir(this.getUpgradedDragAir());
        }
        double d = d25 = upgradeKit ? this.getUpgradedMaxSpeed() : this.getMaxSpeedWithRail();
        double d24 = upgradeKit ? this.getUpgradedAcceleration() : (this.isVehicle() ? this.acceleration : 1.0);
        Vec3 motion = this.getDeltaMovement();
        this.move(MoverType.SELF, new Vec3(Mth.clamp((double)(d24 * motion.x), (double)(-d25), (double)d25), 0.0, Mth.clamp((double)(d24 * motion.z), (double)(-d25), (double)d25)));
    }

    protected double getUpgradedDragAir() {
        return 0.99;
    }

    protected double getUpgradedMaxSpeed() {
        return 1.23;
    }

    protected double getUpgradedAcceleration() {
        return 2.5;
    }

    public Item getDropItem() {
        return (Item)BuiltInRegistries.ITEM.get(this.dropItem);
    }

    public void setCurrentCartSpeedCapOnRail(float value) {
        this.maxSpeed = value;
        super.setCurrentCartSpeedCapOnRail(value);
    }

    public float getMaxCartSpeedOnRail() {
        return this.maxSpeed;
    }

    protected double getMaxSpeed() {
        return super.getMaxSpeed() * 2.0;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.dropItem = ResourceLocation.tryParse((String)compound.getString("DropItem"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("DropItem", this.dropItem.toString());
    }

    public record Abilities<E extends BaseMinecartEntity>(Supplier<EntityType<E>> entityType, ResourceLocation dropItem, float maxSpeed, double acceleration, double dragAir) {
    }
}

