/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.npc;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.Nullable;

public class RandomItemListing
implements VillagerTrades.ItemListing {
    private static final IntegerRange ONE = IntegerRange.of((int)1, (int)1);
    protected final Item price;
    protected final IntegerRange priceRange;
    protected final Item forSale;
    protected final IntegerRange forSaleRange;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;
    private ItemStack priceStack;
    private ItemStack forSaleStack;

    public RandomItemListing(ItemLike price, IntegerRange priceRange, ItemLike forSale, IntegerRange forSaleRange, int maxTrades, int xp, float priceMult) {
        this.price = price.asItem();
        this.priceRange = priceRange;
        this.forSale = forSale.asItem();
        this.forSaleRange = forSaleRange;
        this.maxTrades = maxTrades;
        this.xp = xp;
        this.priceMult = priceMult;
    }

    public RandomItemListing(ItemLike price, ItemLike forSale, int maxTrades, int xp, float priceMult) {
        this(price, ONE, forSale, ONE, maxTrades, xp, priceMult);
    }

    public RandomItemListing(ItemLike price, int priceCount, ItemLike forSale, int maxTrades, int xp, float priceMult) {
        this(price, priceCount, forSale, ONE, maxTrades, xp, priceMult);
    }

    public RandomItemListing(ItemLike price, ItemLike forSale, IntegerRange forSaleRange, int maxTrades, int xp, float priceMult) {
        this(price, ONE, forSale, forSaleRange, maxTrades, xp, priceMult);
    }

    public RandomItemListing(ItemLike price, ItemLike forSale, int forSaleCount, int maxTrades, int xp, float priceMult) {
        this(price, ONE, forSale, IntegerRange.of((int)forSaleCount, (int)forSaleCount), maxTrades, xp, priceMult);
    }

    public RandomItemListing(ItemLike price, int priceCount, ItemLike forSale, int forSaleCount, int maxTrades, int xp, float priceMult) {
        this(price, IntegerRange.of((int)priceCount, (int)priceCount), forSale, IntegerRange.of((int)forSaleCount, (int)forSaleCount), maxTrades, xp, priceMult);
    }

    public RandomItemListing(ItemLike price, int priceCount, ItemLike forSale, IntegerRange forSaleRange, int maxTrades, int xp, float priceMult) {
        this(price, IntegerRange.of((int)priceCount, (int)priceCount), forSale, forSaleRange, maxTrades, xp, priceMult);
    }

    public RandomItemListing(ItemLike price, IntegerRange priceRange, ItemLike forSale, int maxTrades, int xp, float priceMult) {
        this(price, priceRange, forSale, ONE, maxTrades, xp, priceMult);
    }

    public RandomItemListing(ItemLike price, IntegerRange priceRange, ItemLike forSale, int forSaleCount, int maxTrades, int xp, float priceMult) {
        this(price, priceRange, forSale, IntegerRange.of((int)forSaleCount, (int)forSaleCount), maxTrades, xp, priceMult);
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource random) {
        if (this.priceStack == null) {
            this.priceStack = this.price.getDefaultInstance();
            if (Objects.equals(this.priceRange.getMinimum(), this.priceRange.getMaximum())) {
                this.priceStack.setCount(((Integer)this.priceRange.getMinimum()).intValue());
            } else {
                this.priceStack.setCount(random.nextInt(((Integer)this.priceRange.getMinimum()).intValue(), ((Integer)this.priceRange.getMaximum()).intValue()));
            }
        }
        ItemCost cost = new ItemCost(this.priceStack.getItemHolder(), this.priceStack.getCount(), DataComponentPredicate.EMPTY, this.priceStack);
        if (this.forSaleStack == null) {
            this.forSaleStack = this.forSale.getDefaultInstance();
            if (Objects.equals(this.forSaleRange.getMinimum(), this.forSaleRange.getMaximum())) {
                this.forSaleStack.setCount(((Integer)this.forSaleRange.getMinimum()).intValue());
            } else {
                this.forSaleStack.setCount(random.nextInt(((Integer)this.forSaleRange.getMinimum()).intValue(), ((Integer)this.forSaleRange.getMaximum()).intValue()));
            }
        }
        return new MerchantOffer(cost, Optional.empty(), this.forSaleStack, this.maxTrades, this.xp, this.priceMult);
    }
}

