/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.common.item.potion.EffectThrowablePotionItem;

public class EffectThrownPotion
extends ThrowableItemProjectile {
    private EffectThrowablePotionItem item;

    public EffectThrownPotion(EntityType<EffectThrownPotion> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public EffectThrownPotion(double pX, double pY, double pZ, Level pLevel) {
        super((EntityType)ModEntities.EFFECT_THROWN_POTION.get(), pX, pY, pZ, pLevel);
    }

    public EffectThrownPotion(LivingEntity pShooter, Level pLevel) {
        super((EntityType)ModEntities.EFFECT_THROWN_POTION.get(), pShooter, pLevel);
    }

    public void setItem(ItemStack pStack) {
        super.setItem(pStack);
        Item item = pStack.getItem();
        if (item instanceof EffectThrowablePotionItem) {
            EffectThrowablePotionItem effectThrowablePotionItem;
            this.item = effectThrowablePotionItem = (EffectThrowablePotionItem)item;
        }
    }

    protected EffectThrowablePotionItem getDefaultItem() {
        return (EffectThrowablePotionItem)((Object)PotionItems.LOVE_POTION.get());
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (this.level().isClientSide) {
            return;
        }
        if (this.item == null) {
            this.item = this.getDefaultItem();
        }
        Entity entity = this.getEffectSource();
        this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(4.0, 2.0, 4.0)).forEach(living -> {
            if (living.isAffectedByPotions() && this.distanceToSqr((Entity)living) < 16.0) {
                living.addEffect(this.item.data.create(), entity);
            }
        });
        this.level().levelEvent(2002, this.blockPosition(), ((MobEffect)this.item.data.effect().value()).getColor());
        this.discard();
    }
}

