/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.item.flail.FlailItem;
import org.confluence.mod.mixed.IPlayer;
import org.confluence.mod.mixed.Immunity;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.api.entity.IOriented;
import org.confluence.terraentity.mixin.accessor.EntityAccessor;
import org.confluence.terraentity.utils.OBB;
import org.jetbrains.annotations.NotNull;

public class FlailBall
extends Projectile
implements IOriented,
Immunity {
    public long frameCount = 0L;
    private final FlailItem item;
    private InteractionHand hand;
    public float offset;
    public float radians;
    public static final EntityDataAccessor<Float> DATA_OFFSET = SynchedEntityData.defineId(FlailBall.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.defineId(FlailBall.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int PHASE_SPIN = 0;
    public static final int PHASE_THROWN = 1;
    public static final int PHASE_RETRACT = 2;
    public static final int PHASE_FORCE_RETRACT = 3;
    public static final int PHASE_STAY = 4;

    public FlailBall(Level pLevel, FlailItem flailItem) {
        super((EntityType)ModEntities.FLAIL_BALL.get(), pLevel);
        this.setNoGravity(true);
        this.noPhysics = true;
        this.setXRot(-90.0f);
        this.item = flailItem;
    }

    public FlailBall(Level pLevel, Entity owner, InteractionHand hand, FlailItem flailItem) {
        this(pLevel, flailItem);
        this.setOwner(owner);
        this.radians = (float)Math.toRadians(owner.getYRot());
        this.hand = hand;
        this.offset = hand == InteractionHand.MAIN_HAND ? -0.6f : 0.6f;
        this.getEntityData().set(DATA_OFFSET, (Object)Float.valueOf(this.offset));
        this.setPos(owner.position().add((double)(this.offset * Mth.cos((float)this.radians)), 0.0, (double)(this.offset * Mth.sin((float)this.radians))));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_OFFSET, (Object)Float.valueOf(-0.6f));
        builder.define(DATA_PHASE, (Object)0);
    }

    public void tick() {
        LivingEntity living;
        Entity owner = this.getOwner();
        int phase = this.getPhase();
        if (owner == null || owner.isRemoved() || !this.level().isClientSide() && this.item == null || !this.level().isClientSide() && owner instanceof LivingEntity && (living = (LivingEntity)owner).getItemInHand(this.hand).getItem() != this.item || this.position().distanceToSqr(owner.position()) >= 900.0) {
            this.discard();
            if (owner instanceof IPlayer) {
                IPlayer fp = (IPlayer)owner;
                fp.confluence$setFlailBall(null);
            }
            return;
        }
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        this.move(MoverType.SELF, motion);
        switch (phase) {
            case 0: {
                float offset = ((Float)this.getEntityData().get(DATA_OFFSET)).floatValue();
                float radians = (float)Math.toRadians(owner.getYRot());
                this.setPos(owner.position().add((double)(offset * Mth.cos((float)radians)), 0.0, (double)(offset * Mth.sin((float)radians))));
                break;
            }
            case 1: {
                this.noPhysics = false;
                break;
            }
            case 4: {
                this.noPhysics = false;
                this.setNoGravity(false);
                break;
            }
            case 2: 
            case 3: {
                this.noPhysics = true;
                this.setNoGravity(true);
                this.setDeltaMovement(owner.position().add(0.0, 1.5, 0.0).subtract(this.position()).normalize().scale(3.0));
            }
        }
        if (this.position().distanceToSqr(owner.position()) > 256.0) {
            this.setPhase(2);
        }
        this.refreshDimensions();
        if (!this.level().isClientSide()) {
            OBB obb = this.getOrientedBoundingBox();
            AABB border = this.getBoundingBox().inflate(2.0);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, border, EntitySelector.NO_SPECTATORS.and(e -> {
                if (e instanceof Player) {
                    return true;
                }
                return obb.inflate(10.0).collide(e.getBoundingBox(), motion, e.getDeltaMovement());
            }));
            for (LivingEntity living2 : entities) {
                LivingEntity lo;
                if (living2 == owner) {
                    if (phase != 2 && phase != 3) continue;
                    if (owner instanceof IPlayer) {
                        IPlayer fp = (IPlayer)owner;
                        fp.confluence$setFlailBall(null);
                    }
                    this.discard();
                    continue;
                }
                if (!ModUtils.canHitEntity((Entity)living2, owner)) continue;
                living2.hurt(this.damageSources().mobAttack(owner instanceof LivingEntity ? (lo = (LivingEntity)owner) : null), this.item.damage);
            }
        }
    }

    public void move(MoverType pType, Vec3 motion) {
        int phase = this.getPhase();
        if (phase == 1) {
            Vec3 collide = ((EntityAccessor)this).callCollide(motion);
            if (collide.x != motion.x) {
                motion = new Vec3(-motion.x / 2.0, motion.y, motion.z);
            }
            if (collide.y != motion.y) {
                motion = new Vec3(motion.x, -motion.y / 2.0, motion.z);
            }
            if (collide.z != motion.z) {
                motion = new Vec3(motion.x, motion.y, -motion.z / 2.0);
            }
        } else if (phase == 4) {
            motion = new Vec3(motion.x * 0.7, Math.min(0.0, motion.y - 0.4), motion.z * 0.7);
        }
        this.setDeltaMovement(motion);
        super.move(pType, motion);
    }

    public int getPhase() {
        return (Integer)this.getEntityData().get(DATA_PHASE);
    }

    public void setPhase(int phase) {
        if (phase < 0 || phase > 4) {
            throw new IllegalArgumentException("Invalid phase");
        }
        this.getEntityData().set(DATA_PHASE, (Object)phase);
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pPose) {
        if (this.getPhase() == 0) {
            return super.getDimensions(pPose);
        }
        return EntityDimensions.fixed((float)0.75f, (float)0.75f);
    }

    protected void onHitBlock(@NotNull BlockHitResult pResult) {
        Confluence.LOGGER.info("{}", (Object)pResult);
        super.onHitBlock(pResult);
    }

    public OBB getOrientedBoundingBox() {
        Vec3 pos = this.position();
        Entity owner = this.getOwner();
        if (owner == null || (Integer)this.getEntityData().get(DATA_PHASE) != 0) {
            return new OBB(this.getBoundingBox()).updateVertex();
        }
        float offset = ((Float)this.getEntityData().get(DATA_OFFSET)).floatValue() / -2.0f;
        float radians = (float)Math.toRadians(owner.getYRot());
        return new OBB(pos.add((double)(offset * Mth.cos((float)radians)), 1.0, (double)(offset * Mth.sin((float)radians))), 0.7, 2.0, 3.6, 0.0f, owner.getYRot()).updateVertex();
    }

    @Override
    public Immunity.Type confluence$getImmunityType() {
        return Immunity.Type.LOCAL;
    }

    @Override
    public int confluence$getImmunityDuration(DamageSource damageSource) {
        return 7;
    }
}

