/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.entitiy.IAxisZRotate;
import org.confluence.lib.common.entitiy.IBouncy;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.mixed.Immunity;
import org.confluence.mod.util.ModUtils;

public class SpikyBallProjectile
extends Projectile
implements Immunity,
IAxisZRotate,
IBouncy {
    public final IAxisZRotate.Rotate rotate = new IAxisZRotate.Rotate();
    private final Set<Entity> passThrough = new HashSet<Entity>();

    public SpikyBallProjectile(EntityType<SpikyBallProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SpikyBallProjectile(LivingEntity shooter) {
        super((EntityType)ModEntities.SPIKY_BALL_PROJECTILE.get(), shooter.level());
        this.setPos(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.setOwner((Entity)shooter);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        if (this.tickCount > 1200) {
            this.discard();
            return;
        }
        super.baseTick();
        this.bounce((arg_0, arg_1) -> ((SpikyBallProjectile)this).move(arg_0, arg_1), () -> ((SpikyBallProjectile)this).getDeltaMovement(), arg_0 -> ((SpikyBallProjectile)this).setDeltaMovement(arg_0), this.getDefaultGravity(), 0.96);
        if (this.level().isClientSide) {
            this.rotateZ(this.rotate, () -> ((SpikyBallProjectile)this).getDeltaMovement(), (float)this.getDefaultGravity(), 0.125f);
        } else {
            AABB boundingBox = this.getBoundingBox().inflate(1.0);
            EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)boundingBox.getMinPosition(), (Vec3)boundingBox.getMaxPosition(), (AABB)boundingBox, this::canHitEntity, (float)0.5f);
            if (entityHitResult instanceof EntityHitResult) {
                LivingEntity living;
                Entity entity;
                EntityHitResult entityHitResult2 = entityHitResult;
                Entity entity2 = entityHitResult2.getEntity();
                if (entity2.hurt(this.damageSources().mobProjectile((Entity)this, (entity = this.getOwner()) instanceof LivingEntity ? (living = (LivingEntity)entity) : null), 3.2f)) {
                    VectorUtils.knockBackA2B((Entity)this, (Entity)entity2, (double)0.1, (double)0.02);
                }
                if (this.passThrough.add(entity2) && this.passThrough.size() >= 7) {
                    this.discard();
                }
            }
        }
    }

    protected void updateRotation() {
        if (this.rotate.different()) {
            super.updateRotation();
        }
    }

    protected boolean canHitEntity(Entity target) {
        return ModUtils.canHitEntity(target, this.getOwner());
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.tickCount = compound.getInt("Age");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Age", this.tickCount);
    }

    @Override
    public Immunity.Type confluence$getImmunityType() {
        return Immunity.Type.STATIC;
    }

    @Override
    public int confluence$getImmunityDuration(DamageSource damageSource) {
        return 15;
    }
}

