/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.entitiy.IAxisZRotate;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.DamageSettableProjectile;
import org.confluence.mod.common.init.ModDamageTypes;
import org.joml.Vector3f;
import org.mesdag.particlestorm.data.molang.MolangExp;
import org.mesdag.particlestorm.network.EmitterCreationPacketS2C;

public class StormSpearShotProjectile
extends DamageSettableProjectile {
    public final IAxisZRotate.Rotate rotate = new IAxisZRotate.Rotate();

    public StormSpearShotProjectile(EntityType<? extends DamageSettableProjectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide) {
            if (this.rotate.neo > (float)Math.PI * 2) {
                this.rotate.neo -= (float)Math.PI * 2;
            }
            this.rotate.old = this.rotate.neo;
            this.rotate.neo += 1.0f;
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        this.checkInsideBlocks();
        HitResult.Type hitresult$type = hitresult.getType();
        if (hitresult$type == HitResult.Type.BLOCK) {
            this.onHitBlock((BlockHitResult)hitresult);
            this.discard();
        } else if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitresult);
            this.discard();
        }
        if (this.isRemoved()) {
            if (!this.level().isClientSide) {
                EmitterCreationPacketS2C.sendToAll((ResourceLocation)Confluence.asResource("thunder_zapper_expiration"), (Vector3f)this.position().toVector3f(), (MolangExp)MolangExp.EMPTY, null);
            }
            return;
        }
        Vec3 vec3 = this.getDeltaMovement();
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        this.setPos(offX, offY, offZ);
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        if (!this.level().isClientSide) {
            result.getEntity().hurt(ModDamageTypes.of(this.level(), (ResourceKey<DamageType>)DamageTypes.STING, (Entity)this, this.getOwner()), this.getCalculatedDamage());
            VectorUtils.knockBackA2B((Entity)this, (Entity)result.getEntity(), (double)0.15, (double)0.05);
        }
    }
}

