/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.DamageSettableProjectile;

public class ThrowableDropSelfProjectile
extends DamageSettableProjectile {
    private static final EntityDataAccessor<Integer> DATA_FLY_TICKS = SynchedEntityData.defineId(ThrowableDropSelfProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(ThrowableDropSelfProjectile.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private int penetrate = 0;
    private float damage = 4.2f;
    private float deltaDamage = this.damage * 0.1f;
    private final List<Entity> hitList = new ArrayList<Entity>();

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder.define(DATA_FLY_TICKS, (Object)5).define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY));
    }

    public ThrowableDropSelfProjectile(EntityType<? extends ThrowableDropSelfProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void setOwner(@Nullable Entity player) {
        super.setOwner(player);
        if (player != null) {
            this.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
        }
    }

    public void setItem(ItemStack drop) {
        this.entityData.set(DATA_ITEM_STACK, (Object)drop);
    }

    public ItemStack getItem() {
        return (ItemStack)this.entityData.get(DATA_ITEM_STACK);
    }

    public void setFlyTicks(int ticks) {
        this.entityData.set(DATA_FLY_TICKS, (Object)ticks);
    }

    public int getFlyTicks() {
        return (Integer)this.entityData.get(DATA_FLY_TICKS);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        Entity entity = pResult.getEntity();
        if (this.canHitEntity(entity)) {
            this.hitList.add(entity);
            if (entity.hurt(this.getDamageSource(), this.damage)) {
                this.damage -= this.deltaDamage;
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)0.5, (double)0.2);
                if (this.penetrate == 3) {
                    if (this.random.nextBoolean()) {
                        LibUtils.createItemEntity((ItemStack)this.getItem(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (Level)this.level(), (int)0);
                    }
                    this.discard();
                } else {
                    ++this.penetrate;
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        if (this.random.nextBoolean()) {
            LibUtils.createItemEntity((ItemStack)this.getItem(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (Level)this.level(), (int)0);
        }
        this.discard();
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
        this.deltaDamage = damage * 0.1f;
    }

    @Override
    public boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && !this.hitList.contains(target);
    }

    protected void applyGravity() {
        if (this.tickCount > this.getFlyTicks()) {
            super.applyGravity();
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return true;
    }

    public void tick() {
        float f;
        super.tick();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.hitTargetOrDeflectSelf(hitresult);
        }
        this.checkInsideBlocks();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
            }
            f = 0.8f;
        } else {
            f = 0.99f;
        }
        this.setDeltaMovement(vec3.scale((double)f));
        this.applyGravity();
        this.setPos(d0, d1, d2);
    }

    protected double getDefaultGravity() {
        return 0.08;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Item", 10)) {
            this.setItem(ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compound.getCompound("Item")).orElse(ItemStack.EMPTY));
        } else {
            this.setItem(ItemStack.EMPTY);
        }
    }
}

