/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.MultiplyExplosionDamageCalculator;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.util.TerraStyleExplosion;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class BaseBombEntity
extends ThrowableItemProjectile {
    public static final ResourceLocation PARTICLE = Confluence.asResource("bomb_lead");
    public static final float DIAMETER = 0.375f;
    protected float diameter = 0.375f;
    public float rotateO = 0.0f;
    public float rotate = 0.0f;
    public Vector3f rotation = new Vector3f();
    public ParticleEmitter emitter;
    protected int delay = 60;
    protected float blastPower = 5.0f;
    protected double bounceFactor = 0.2;
    protected double frictionFactor = 0.9;

    public BaseBombEntity(EntityType<? extends BaseBombEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BaseBombEntity(EntityType<? extends BaseBombEntity> pEntityType, LivingEntity pShooter) {
        super(pEntityType, pShooter, pShooter.level());
    }

    public BaseBombEntity(LivingEntity pShooter) {
        this((EntityType<? extends BaseBombEntity>)((EntityType)ModEntities.BOMB_ENTITY.get()), pShooter);
    }

    protected Item getDefaultItem() {
        return Items.AIR;
    }

    protected void blockHitCallBack(BlockHitResult hitBlock) {
    }

    protected void explodeFunction(ServerLevel level) {
        TerraStyleExplosion.terraExplode(level, (Entity)this, Explosion.getDefaultDamageSource((Level)level, (Entity)this), this.getExplosionDamageCalculator(), this.getX(), this.getY(), this.getZ(), this.blastPower, Level.ExplosionInteraction.TNT);
    }

    protected ExplosionDamageCalculator getExplosionDamageCalculator() {
        return new MultiplyExplosionDamageCalculator(0.2f);
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        this.blockHitCallBack(pResult);
        Vec3 motion = VectorUtils.relativeScale((Vec3)this.getDeltaMovement(), (Direction.Axis)pResult.getDirection().getAxis(), (double)(-this.bounceFactor));
        if (Math.abs(motion.y) < 0.03) {
            motion = new Vec3(motion.x, 0.0, motion.z);
        }
        this.setDeltaMovement(motion.scale(this.frictionFactor));
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.delay-- < 0) {
                this.explodeFunction(level2);
                this.discard();
            }
        } else {
            float s = (float)this.getDeltaMovement().length();
            if ((double)s > (double)2.0E-5f + this.getDefaultGravity()) {
                float r = 2.0f * s / this.diameter;
                if (this.rotate > (float)Math.PI * 2) {
                    this.rotate -= (float)Math.PI * 2;
                }
                this.rotateO = this.rotate;
                this.rotate += r / (float)Math.PI;
                this.rotation.set(0.0, 0.0, (double)this.rotate);
            } else {
                this.rotateO = this.rotate;
            }
            this.createEmitter();
        }
    }

    protected void updateRotation() {
        if (this.rotate != this.rotateO) {
            super.updateRotation();
        }
    }

    protected void createEmitter() {
        if (this.emitter == null || this.emitter.isRemoved()) {
            this.emitter = new ParticleEmitter(this.level(), this.position(), this.getLeadParticle());
            this.emitter.offsetRot.set(0.0, 1.5707963705062866, 0.0);
            this.emitter.offsetPos = new Vec3(0.0, 0.375, 0.0);
            this.emitter.parentRotation = this.rotation;
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
    }

    public double getDefaultGravity() {
        return 0.05;
    }

    protected ResourceLocation getLeadParticle() {
        return PARTICLE;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.delay = compound.getInt("Delay");
        this.blastPower = compound.getFloat("BlastPower");
        this.bounceFactor = compound.getDouble("BounceFactor");
        this.frictionFactor = compound.getDouble("FrictionFactor");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Delay", this.delay);
        compound.putFloat("BlastPower", this.blastPower);
        compound.putDouble("BounceFactor", this.bounceFactor);
        compound.putDouble("FrictionFactor", this.frictionFactor);
    }

    public static void itemInvulnerableToExplosion(@Nullable Entity directSourceEntity, List<Entity> affectedEntities) {
        if (directSourceEntity instanceof BaseBombEntity) {
            affectedEntities.removeIf(entity -> entity instanceof ItemEntity);
        }
    }
}

