/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.bomb;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.MultiplyExplosionDamageCalculator;
import org.confluence.mod.common.entity.projectile.bomb.BaseBombEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.util.TerraStyleExplosion;

public class BaseDynamiteEntity
extends BaseBombEntity {
    public static final float DIAMETER = 0.25f;
    public static final float BLAST_POWER = 10.0f;

    public BaseDynamiteEntity(EntityType<? extends BaseDynamiteEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.delay = 100;
        this.diameter = 0.25f;
        this.blastPower = 10.0f;
    }

    public BaseDynamiteEntity(EntityType<? extends BaseDynamiteEntity> pEntityType, LivingEntity pShooter) {
        super(pEntityType, pShooter);
        this.delay = 100;
        this.diameter = 0.25f;
        this.blastPower = 10.0f;
    }

    public BaseDynamiteEntity(LivingEntity pShooter) {
        super((EntityType<? extends BaseBombEntity>)((EntityType)ModEntities.DYNAMITE.get()), pShooter);
        this.delay = 100;
        this.diameter = 0.25f;
        this.blastPower = 10.0f;
    }

    @Override
    protected void explodeFunction(ServerLevel level) {
        TerraStyleExplosion.terraExplode(level, (Entity)this, Explosion.getDefaultDamageSource((Level)level, (Entity)this), (ExplosionDamageCalculator)new MultiplyExplosionDamageCalculator(0.2f), this.getX(), this.getY(), this.getZ(), this.blastPower, Level.ExplosionInteraction.TNT);
    }

    @Override
    protected void createEmitter() {
    }
}

