/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModDamageTypes;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public abstract class AbstractBoulderEntity
extends Projectile {
    private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE = SynchedEntityData.defineId(AbstractBoulderEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    protected final Object2IntOpenHashMap<UUID> hitHistory = new Object2IntOpenHashMap();
    private final BlockState particleBlockState;
    private final ParticleType<BlockParticleOption> particleType;
    private final SoundEvent sound;
    private final SoundSource soundCategory;
    private final double minRemoveSpeed;
    private final double defaultGravity;
    private float rotate;
    public float rotateO;
    private int landingCount;
    private boolean isTracking;
    private double speed;
    private final float sizeRadius;
    private float trackingRange;
    private int stillTick;

    public AbstractBoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, BlockState blockState) {
        this(entityType, level, blockState, BoulderEntity.Builder.of());
    }

    public AbstractBoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, BlockState blockState, BoulderEntity.Builder builder) {
        this(entityType, level, Vec3.ZERO, blockState, builder);
    }

    public AbstractBoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, Vec3 pos, BlockState blockState) {
        this(entityType, level, pos, blockState, BoulderEntity.Builder.of());
    }

    public AbstractBoulderEntity(EntityType<? extends AbstractBoulderEntity> entityType, Level level, Vec3 pos, BlockState blockState, BoulderEntity.Builder builder) {
        super(entityType, level);
        this.setPos(pos);
        this.trackingRange = builder.trackingRange;
        this.speed = builder.speed;
        this.minRemoveSpeed = builder.minRemoveSpeed;
        this.sizeRadius = builder.sizeRadius;
        this.landingCount = builder.landingCount;
        this.particleBlockState = builder.particleBlockState;
        this.particleType = builder.particleType;
        this.sound = builder.sound;
        this.soundCategory = builder.soundCategory;
        this.defaultGravity = builder.defaultGravity;
        this.setBlockState(blockState);
    }

    public void tick() {
        super.tick();
        this.move();
        this.updateNeighbors();
        this.scrollRotate();
        this.onHit(this.getHitResult());
        BlockHitResult clipped = this.level().clip(new ClipContext(this.position(), this.position(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (clipped.isInside() || this.stillTick >= 20) {
            this.onRemoveBroken(true);
        }
        if (this.onGround() && this.getDeltaMovement().length() <= this.minRemoveSpeed) {
            ++this.stillTick;
            return;
        }
        this.stillTick = 0;
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.worldInit();
    }

    protected void worldInit() {
        Vec3 position = this.position();
        ClipContext context = new ClipContext(position, position.relative(Direction.DOWN, 1.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
        if (this.level().clip(context).getType() == HitResult.Type.MISS) {
            return;
        }
        this.findLocation(position);
    }

    public void onRemoveBroken(boolean timeoutUrNot) {
        ServerLevel serverLevel;
        block3: {
            block2: {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                if (!this.isRemoved()) break block3;
            }
            return;
        }
        this.brokenFunction(serverLevel, timeoutUrNot);
        this.discard();
    }

    protected void brokenFunction(ServerLevel serverLevel, boolean timeoutUrNot) {
        BlockPos pos = this.blockPosition();
        this.brokenParticles(serverLevel, pos);
        this.brokenSound(serverLevel, pos);
    }

    public void brokenParticles(ServerLevel serverLevel, BlockPos pos) {
        BlockState state = this.particleBlockState == null ? this.getBlockState() : this.particleBlockState;
        serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(this.particleType, state).setPos(pos), this.getX(), this.getY() + 0.5, this.getZ(), 175, 0.0, 0.0, 0.0, 0.15);
    }

    public void brokenSound(ServerLevel serverLevel, BlockPos pos) {
        serverLevel.playSound(null, pos, this.sound, this.soundCategory, 5.0f, 1.0f);
    }

    protected HitResult getHitResult() {
        EntityHitResult hitResult1;
        Vec3 end;
        Level level = this.level();
        Vec3 delta = this.getDeltaMovement();
        delta = delta.add((double)((float)Mth.sign((double)delta.x) * this.sizeRadius), (double)((float)Mth.sign((double)delta.y) * this.sizeRadius), (double)((float)Mth.sign((double)delta.z) * this.sizeRadius));
        Vec3 start = this.position();
        BlockHitResult hitResult = level.clip(new ClipContext(start, end = start.add(delta), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (hitResult.getType() != HitResult.Type.MISS) {
            end = hitResult.getLocation();
        }
        if ((hitResult1 = ProjectileUtil.getEntityHitResult((Level)level, (Entity)this, (Vec3)start, (Vec3)end, (AABB)this.getBoundingBox().expandTowards(delta).inflate(1.0), x$0 -> this.canHitEntity((Entity)x$0))) != null) {
            hitResult = hitResult1;
        }
        return hitResult;
    }

    protected void onHit(HitResult hitResult) {
        if (hitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (blockHitResult.isInside()) {
                this.onRemoveBroken(false);
                return;
            }
            this.onHitBlock(blockHitResult);
            return;
        }
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            this.onHitEntity(entityHitResult);
        }
    }

    protected void scrollRotate() {
        this.rotate();
        Vec3 delta = this.getDeltaMovement();
        float s = (float)delta.length();
        float r = s / this.sizeRadius;
        if (this.rotate > (float)Math.PI * 2) {
            this.rotate -= (float)Math.PI * 2;
        }
        this.rotateO = this.rotate;
        this.rotate += r;
    }

    protected void rotate() {
        Vec3 v = this.getDeltaMovement();
        this.yRotO = this.getYRot();
        this.setYRot((float)(Mth.atan2((double)(-v.x), (double)v.z) * 57.2957763671875));
    }

    protected void move() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x, vec3.y - this.getGravity(), vec3.z);
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.99));
        this.rotate();
    }

    protected void updateNeighbors() {
        if (!this.level().isClientSide) {
            for (Direction dir : LibUtils.DIRECTIONS) {
                BlockPos blockPos = this.blockPosition().relative(dir);
                BlockState blockState = this.level().getBlockState(blockPos);
                Block block = blockState.getBlock();
                if (!(block instanceof AbstractBoulderBlock)) continue;
                AbstractBoulderBlock block2 = (AbstractBoulderBlock)block;
                BlockHitResult hitResult = new BlockHitResult(blockPos.getCenter(), dir, blockPos, false);
                block2.onProjectileHit(this.level(), blockState, hitResult, this);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.99));
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        Direction.Axis axis;
        super.onHitBlock(blockHitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = blockHitResult.getBlockPos();
            Vec3 vec3 = blockHitResult.getLocation();
            BlockState blockState = level.getBlockState(pos);
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(this.particleType, blockState).setPos(pos), vec3.x, vec3.y, vec3.z, 175, 0.0, 0.0, 0.0, 0.15);
            serverLevel.playSound(null, pos, this.sound, this.soundCategory, 10.0f, 1.0f);
        }
        if ((axis = blockHitResult.getDirection().getAxis()) == Direction.Axis.Y) {
            this.onVerticalBlockHit(blockHitResult);
            return;
        }
        this.onHorizontalBlockHit(blockHitResult);
    }

    protected void onHorizontalBlockHit(BlockHitResult blockHitResult) {
        this.onRemoveBroken(false);
    }

    protected void onVerticalBlockHit(BlockHitResult blockHitResult) {
        if (this.landingCount <= 0 || blockHitResult.getDirection() != Direction.UP) {
            this.onRemoveBroken(false);
            return;
        }
        Vec3 vec3 = blockHitResult.getLocation();
        this.findLocation(this.getAdjustMoveVector(vec3, -1.0));
        --this.landingCount;
    }

    protected Vec3 getAdjustMoveVector(Vec3 vec3, double v) {
        return vec3.subtract(vec3.scale(Math.pow(vec3.length(), v * (double)(this.getSizeRadius() * 2.0f))));
    }

    protected void findLocation(Vec3 pos) {
        Level level = this.level();
        Vec3 position = this.position();
        Vec3 moveVector = this.getDeltaMovement();
        if (moveVector.x == 0.0 && moveVector.z == 0.0 && this.targetPlayer(this.level().getNearestPlayer((Entity)this, (double)this.trackingRange))) {
            return;
        }
        Vec3 targetPos = null;
        boolean isTranslation = false;
        for (int i = 1; i >= 0; --i) {
            if (i == 0) {
                isTranslation = true;
            }
            List<Direction> list = this.getDirectionList(pos, level, i, position, i == 0);
            int size = list.size();
            if (list.isEmpty()) continue;
            if (size > 1) {
                Direction direction = list.get(this.getRandom().nextIntBetweenInclusive(0, size - 1));
                targetPos = position.relative(direction, 1.0);
                break;
            }
            targetPos = position.relative(list.getFirst(), 1.0);
            break;
        }
        Vec3 subtract = null;
        if (isTranslation && this.targetPlayer(this.level().getNearestPlayer((Entity)this, (double)this.trackingRange))) {
            return;
        }
        if (targetPos != null) {
            subtract = new Vec3(targetPos.x, position.y, targetPos.z);
        }
        if (moveVector.x != 0.0 || moveVector.z != 0.0) {
            return;
        }
        if (subtract == null) {
            return;
        }
        Vec3 orientation = this.orientationHorizontal(subtract).scale(this.speed);
        this.setDeltaMovement(new Vec3(orientation.x, orientation.y, orientation.z));
    }

    private List<Direction> getDirectionList(Vec3 pos, Level level, int finalY, Vec3 position, boolean isParallel) {
        return Direction.Plane.HORIZONTAL.stream().map(direction -> {
            Vec3 from = isParallel ? position : position.relative(direction, 1.0);
            Vec3 to = pos.relative(direction, 1.0).relative(Direction.DOWN, (double)finalY);
            ClipContext context = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this);
            return Map.entry(direction, level.clip(context));
        }).filter(hitResult -> ((BlockHitResult)hitResult.getValue()).getType() == HitResult.Type.MISS).map(Map.Entry::getKey).toList();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        double lengthSqr = this.getDeltaMovement().length();
        if (lengthSqr <= 0.05) {
            return;
        }
        Entity entity = entityHitResult.getEntity();
        if (!entity.isAlive() || !entity.isAttackable() || entity.equals((Object)this.getOwner())) {
            return;
        }
        UUID uuid = entity.getUUID();
        if ((this.hitHistory.containsKey((Object)uuid) ? this.hitHistory.addTo((Object)uuid, -1) : 0) > 0) {
            return;
        }
        DamageSource damageSource = ModDamageTypes.of(entity.level(), ModDamageTypes.BOULDER, (Entity)this);
        entity.hurt(damageSource, 100.0f);
        this.hitHistory.put((Object)uuid, 5);
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
    }

    public boolean targetPlayer(@Nullable Player player) {
        boolean pathBlocked;
        Vec3 cornerPos2;
        Vec3 cornerPos1;
        if (player == null || !player.isAlive() || player.equals((Object)this.getOwner())) {
            return false;
        }
        Vec3 currentPos = this.position();
        Vec3 targetPos = player.position();
        if (targetPos.y > currentPos.y) {
            return false;
        }
        double dx = targetPos.x - currentPos.x;
        double dy = targetPos.y - currentPos.y;
        double dz = targetPos.z - currentPos.z;
        double absDx = Math.abs(dx);
        double absDy = Math.abs(dy);
        double absDz = Math.abs(dz);
        if (absDx >= absDy && absDx >= absDz) {
            if (absDy >= absDz) {
                cornerPos1 = new Vec3(targetPos.x, currentPos.y, currentPos.z);
                cornerPos2 = new Vec3(targetPos.x, targetPos.y, currentPos.z);
            } else {
                cornerPos1 = new Vec3(targetPos.x, currentPos.y, currentPos.z);
                cornerPos2 = new Vec3(targetPos.x, currentPos.y, targetPos.z);
            }
        } else if (absDy >= absDx && absDy >= absDz) {
            if (absDx >= absDz) {
                cornerPos1 = new Vec3(currentPos.x, targetPos.y, currentPos.z);
                cornerPos2 = new Vec3(targetPos.x, targetPos.y, currentPos.z);
            } else {
                cornerPos1 = new Vec3(currentPos.x, targetPos.y, currentPos.z);
                cornerPos2 = new Vec3(currentPos.x, targetPos.y, targetPos.z);
            }
        } else if (absDx >= absDy) {
            cornerPos1 = new Vec3(currentPos.x, currentPos.y, targetPos.z);
            cornerPos2 = new Vec3(targetPos.x, currentPos.y, targetPos.z);
        } else {
            cornerPos1 = new Vec3(currentPos.x, currentPos.y, targetPos.z);
            cornerPos2 = new Vec3(currentPos.x, targetPos.y, targetPos.z);
        }
        boolean bl = pathBlocked = this.isPathBlocked(currentPos, targetPos) || this.isPathBlocked(currentPos, cornerPos1) || this.isPathBlocked(cornerPos1, cornerPos2) || this.isPathBlocked(cornerPos2, targetPos);
        if (pathBlocked) {
            return false;
        }
        this.setDeltaMovement(this.orientationHorizontal(targetPos).scale(this.speed));
        return true;
    }

    private boolean isPathBlocked(Vec3 start, Vec3 end) {
        return this.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this)).getType() != HitResult.Type.MISS;
    }

    protected Vec3 orientationHorizontal(Vec3 pos) {
        return this.orientationHorizontal(this.position(), pos);
    }

    protected Vec3 orientationHorizontal(Vec3 pos, Vec3 pos1) {
        Vector2d vec = new Vector2d(pos1.x, pos1.z).sub((Vector2dc)new Vector2d(pos.x, pos.z)).normalize();
        return new Vec3(vec.x, pos1.y, vec.y);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_BLOCK_STATE, (Object)this.getDefaultBlockState());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (!tag.contains("BlockState")) {
            tag.put("BlockState", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getBlockState()).getOrThrow());
        }
        this.setBlockState((BlockState)BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("BlockState")).getOrThrow());
        if (tag.contains("LandingCount")) {
            this.landingCount = tag.getInt("LandingCount");
        }
        if (tag.contains("IsTracking")) {
            this.isTracking = tag.getBoolean("IsTracking");
        }
        if (tag.contains("Speed")) {
            this.speed = tag.getDouble("Speed");
        }
        if (tag.contains("TrackingRange")) {
            this.trackingRange = tag.getFloat("TrackingRange");
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("BlockState", (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.getBlockState()).getOrThrow());
        tag.putInt("LandingCount", this.landingCount);
        tag.putBoolean("IsTracking", this.isTracking);
        tag.putDouble("Speed", this.speed);
        tag.putFloat("TrackingRange", this.trackingRange);
    }

    protected double getDefaultGravity() {
        return this.defaultGravity;
    }

    public boolean fireImmune() {
        return true;
    }

    public float getRotate() {
        return this.rotate;
    }

    public void setRotate(float rotate) {
        this.rotate = rotate;
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(DATA_BLOCK_STATE);
    }

    public abstract BlockState getDefaultBlockState();

    public void setBlockState(BlockState blockState) {
        this.entityData.set(DATA_BLOCK_STATE, (Object)blockState);
    }

    public float getTrackingRange() {
        return this.trackingRange;
    }

    public void setTrackingRange(float trackingRange) {
        this.trackingRange = trackingRange;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getMinRemoveSpeed() {
        return this.minRemoveSpeed;
    }

    public float getSizeRadius() {
        return this.sizeRadius;
    }

    public int getLandingCount() {
        return this.landingCount;
    }

    public void setLandingCount(int landingCount) {
        this.landingCount = landingCount;
    }

    public BlockState getParticleBlockState() {
        return this.particleBlockState;
    }

    public ParticleType<BlockParticleOption> getParticleType() {
        return this.particleType;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public SoundSource getSoundCategory() {
        return this.soundCategory;
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    public void setTracking(boolean tracking) {
        this.isTracking = tracking;
    }
}

