/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.entity.projectile.boulder.AbstractBoulderEntity;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.jetbrains.annotations.Nullable;

public class FollowerBoulderEntity
extends AbstractBoulderEntity {
    public static final BlockState DEFAULT_BLOCK_STATE = ((AbstractBoulderBlock)FunctionalBlocks.FOLLOWER_BOULDER.get()).defaultBlockState();
    private int tick = 0;
    private Player target;

    public FollowerBoulderEntity(EntityType<FollowerBoulderEntity> entityType, Level pLevel) {
        super(entityType, pLevel, DEFAULT_BLOCK_STATE, BoulderEntity.Builder.of());
        this.setTracking(true);
    }

    public FollowerBoulderEntity(Level level, Vec3 pos, BlockState blockState, BoulderEntity.Builder builder) {
        super((EntityType<? extends AbstractBoulderEntity>)((EntityType)ModEntities.FOLLOWER_BOULDER.get()), level, pos, blockState, builder);
        this.setTracking(true);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tick++ >= 400 || this.target != null && this.distanceTo((Entity)this.target) >= 30.0f) {
            this.onRemoveBroken(true);
        }
    }

    @Override
    protected void move() {
        if (!this.level().getBlockState(this.getOnPos(-1.0f)).isAir() && this.target != null) {
            Vec3 vec3 = this.target.position().subtract(this.position()).normalize();
            vec3 = new Vec3(vec3.x, 0.0, vec3.z);
            this.setDeltaMovement(vec3.scale(this.getSpeed()));
        }
        super.move();
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        if (entityHitResult.getEntity().equals((Object)this.target)) {
            this.onRemoveBroken(false);
        }
    }

    @Override
    public boolean targetPlayer(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        super.targetPlayer(player);
        this.target = player;
        return true;
    }

    @Override
    public BlockState getDefaultBlockState() {
        return DEFAULT_BLOCK_STATE;
    }
}

