/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.entity.projectile.boulder.AbstractBoulderEntity;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class RollingCactusBoulderEntity
extends AbstractBoulderEntity {
    private static final BoulderEntity.Builder BUILDER = BoulderEntity.Builder.of().minRemoveSpeed(0.05).speed(0.3).particle(Blocks.CACTUS.defaultBlockState()).sound(SoundEvents.WOOL_BREAK);
    public static final BlockState DEFAULT_BLOCK_STATE = ((AbstractBoulderBlock)FunctionalBlocks.ROLLING_CACTUS_BOULDER.get()).defaultBlockState();

    public RollingCactusBoulderEntity(EntityType<RollingCactusBoulderEntity> entityType, Level pLevel) {
        super(entityType, pLevel, DEFAULT_BLOCK_STATE, BUILDER);
    }

    public RollingCactusBoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        this(level, pos, blockState, BUILDER);
    }

    public RollingCactusBoulderEntity(Level level, Vec3 pos, BlockState blockState, BoulderEntity.Builder builder) {
        super((EntityType<? extends AbstractBoulderEntity>)((EntityType)ModEntities.ROLLING_CACTUS_BOULDER.get()), level, pos, blockState, BUILDER.inherit(builder));
    }

    @Override
    protected void brokenFunction(ServerLevel serverLevel, boolean timeoutUrNot) {
        int count = this.random.nextInt(6, 13);
        float y = this.random.nextFloat() * (float)Math.PI;
        float d = (float)Math.PI * 2 / (float)count;
        for (int i = 0; i < count; ++i) {
            float x = -Mth.nextFloat((RandomSource)this.random, (float)0.7853982f, (float)1.2566371f);
            SpikeProjectile projectile = new SpikeProjectile((EntityType<? extends Projectile>)((EntityType)ModEntities.ROLLING_CACTUS_SPIKE.get()), this.level());
            float cos = Mth.cos((float)x);
            float f = -Mth.sin((float)y) * cos;
            float f1 = -Mth.sin((float)x);
            float f2 = Mth.cos((float)y) * cos;
            projectile.setPos(this.position().add(0.0, 1.25, 0.0));
            projectile.shoot(f, f1, f2, 0.4f, 0.1f);
            this.level().addFreshEntity((Entity)projectile);
            y += d;
        }
        super.brokenFunction(serverLevel, timeoutUrNot);
    }

    @Override
    public BlockState getDefaultBlockState() {
        return DEFAULT_BLOCK_STATE;
    }

    public static class SpikeProjectile
    extends Projectile {
        public SpikeProjectile(EntityType<? extends Projectile> entityType, Level level) {
            super(entityType, level);
        }

        protected void defineSynchedData(SynchedEntityData.Builder builder) {
        }

        public void tick() {
            EntityHitResult entityHitResult;
            Entity entity;
            HitResult hitResult;
            super.tick();
            Vec3 vec3 = this.getDeltaMovement();
            this.move(MoverType.SELF, vec3);
            Vec3 motion = this.getDeltaMovement();
            if (motion.x != vec3.x || motion.y != vec3.y || motion.z != vec3.z) {
                this.discard();
            } else if (!this.level().isClientSide && (hitResult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity)) instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)hitResult).getEntity()).hurt(this.damageSources().cactus(), 8.0f)) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)entity, (double)1.0, (double)0.2);
            }
            this.setDeltaMovement(motion.add(0.0, -0.08, 0.0));
            if (this.tickCount > 200) {
                this.discard();
            }
        }

        protected boolean canHitEntity(Entity target) {
            return target.canBeHitByProjectile() && target != this.getOwner();
        }
    }
}

