/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.boulder;

import com.mojang.serialization.DynamicOps;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.block.common.TombstoneBlock;
import org.confluence.mod.common.entity.projectile.boulder.AbstractBoulderEntity;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.jetbrains.annotations.Nullable;

public class TombstoneBoulderEntity
extends AbstractBoulderEntity {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final BlockState DEFAULT_BLOCK_STATE = ((TombstoneBlock)((Object)ModBlocks.TOMBSTONE.get())).defaultBlockState();
    private SignText text = new SignText();
    private static final BoulderEntity.Builder BUILDER = BoulderEntity.Builder.of().minRemoveSpeed(0.1).speed(0.2);

    public TombstoneBoulderEntity(EntityType<TombstoneBoulderEntity> entityType, Level pLevel) {
        super(entityType, pLevel, DEFAULT_BLOCK_STATE, BUILDER);
    }

    public TombstoneBoulderEntity(Level level, Vec3 pos, BlockState blockState) {
        this(level, pos, blockState, BUILDER);
    }

    public TombstoneBoulderEntity(Level level, Vec3 pos, BlockState blockState, BoulderEntity.Builder builder) {
        super((EntityType<? extends AbstractBoulderEntity>)((EntityType)ModEntities.TOMBSTONE_BOULDER.get()), level, pos, blockState, BUILDER.inherit(builder));
    }

    @Override
    public void onRemoveBroken(boolean timeoutUrNot) {
        ServerLevel serverLevel;
        block7: {
            block6: {
                Level level = this.level();
                if (!(level instanceof ServerLevel)) break block6;
                serverLevel = (ServerLevel)level;
                if (!this.isRemoved()) break block7;
            }
            return;
        }
        BlockPos blockPos = this.blockPosition();
        if (!Block.canSupportRigidBlock((BlockGetter)serverLevel, (BlockPos)blockPos.offset(0, -1, 0)) || !serverLevel.getBlockState(blockPos).canBeReplaced()) {
            if (timeoutUrNot) {
                this.discard();
            }
            return;
        }
        serverLevel.setBlock(blockPos, this.getBlockState(), 3);
        BlockEntity blockEntity = serverLevel.getBlockEntity(blockPos);
        if (blockEntity instanceof TombstoneBlock.BEntity) {
            TombstoneBlock.BEntity entity = (TombstoneBlock.BEntity)blockEntity;
            entity.setText(this.text, true);
        }
        this.brokenFunction(serverLevel, timeoutUrNot);
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        if (!ModSecretSeeds.FOR_THE_WORTHY.match()) {
            return;
        }
        super.onHitEntity(entityHitResult);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("text", (Tag)SignText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.text).getOrThrow());
    }

    @Override
    public BlockState getDefaultBlockState() {
        return DEFAULT_BLOCK_STATE;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.text = (SignText)SignText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("text")).getOrThrow();
    }

    public static void createTombstoneEntity(LivingEntity living) {
        if (!((Boolean)CommonConfigs.DROPS_TOMBSTONE.get()).booleanValue()) {
            return;
        }
        BlockState blockState = TombstoneBoulderEntity.selectTombstone(living);
        if (blockState == null) {
            return;
        }
        Level level = living.level();
        Vec3 position = living.position();
        TombstoneBoulderEntity entity = new TombstoneBoulderEntity(level, position, blockState);
        entity.text = entity.text.setMessage(0, living.getCombatTracker().getDeathMessage()).setMessage(1, (Component)Component.literal((String)DATE_FORMAT.format(Calendar.getInstance().getTime())));
        if (!level.getBlockState(living.blockPosition().below()).isAir()) {
            entity.setTracking(true);
            entity.targetPlayer(level.getNearestPlayer(position.x, position.y, position.z, (double)entity.getTrackingRange(), Entity::isAlive));
        }
        level.addFreshEntity((Entity)entity);
    }

    @Nullable
    public static BlockState selectTombstone(LivingEntity living) {
        boolean isGolden;
        if (living instanceof Player) {
            Player player = (Player)living;
            isGolden = PlayerUtils.getMoney(player, true) >= 100000L;
        } else if (living instanceof AbstractTerraNPC && living.level().getLevelData().isHardcore()) {
            isGolden = false;
        } else {
            return null;
        }
        return (BlockState)Util.getRandom((Object[])((BlockState[])ModBlocks.TOMBSTONES.object2BooleanEntrySet().stream().filter(entry -> entry.getBooleanValue() == isGolden).map(entry -> ((TombstoneBlock)((Object)((Object)((DeferredBlock)entry.getKey()).get()))).defaultBlockState()).toArray(BlockState[]::new)), (RandomSource)living.getRandom());
    }
}

