/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class BallOfFrostProjectile
extends AbstractManaProjectile {
    private int collideCount = 0;
    private ParticleEmitter emitter;

    public BallOfFrostProjectile(EntityType<? extends AbstractManaProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BallOfFrostProjectile(Player player) {
        super((EntityType<? extends AbstractManaProjectile>)((EntityType)ModEntities.BALL_OF_FROST_PROJECTILE.get()), player.level());
        this.setOwner((Entity)player);
        this.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
    }

    public void baseTick() {
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3);
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
            if (this.collideCount++ >= 8) {
                this.discard();
                return;
            }
        }
        this.setDeltaMovement(motion);
        if (this.level().isClientSide && (this.emitter == null || this.emitter.isRemoved())) {
            this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("ball_of_frost"));
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
        if (this.tickCount > 1200) {
            this.discard();
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(ModEffects.FROSTBITE, Mth.randomBetweenInclusive((RandomSource)living.getRandom(), (int)100, (int)280)));
        }
        this.doHurtAndKnockback(entity, 0.65, 0.2);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.collideCount = compound.getInt("CollideCount");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CollideCount", this.collideCount);
    }
}

