/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.color.FloatRGB;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.data.molang.MolangExp;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class BaseManaStaffProjectileEntity
extends AbstractManaProjectile {
    protected static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.defineId(BaseManaStaffProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected int penetrateCount = 2;
    protected ParticleEmitter emitter;

    public BaseManaStaffProjectileEntity(EntityType<? extends BaseManaStaffProjectileEntity> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public BaseManaStaffProjectileEntity(LivingEntity living, Variant variant) {
        this((EntityType<? extends BaseManaStaffProjectileEntity>)((EntityType)ModEntities.BASE_MANA_STAFF_PROJECTILE.get()), living, living.level(), variant);
    }

    public BaseManaStaffProjectileEntity(EntityType<? extends BaseManaStaffProjectileEntity> entityType, LivingEntity living, Level level, Variant variant) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
        this.setOwner((Entity)living);
        this.setNoGravity(variant.gravity <= 0.0);
        this.setVariant(variant);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder.define(DATA_VARIANT_ID, (Object)0));
    }

    public void setVariant(Variant pVariant) {
        this.entityData.set(DATA_VARIANT_ID, (Object)pVariant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.entityData.get(DATA_VARIANT_ID));
    }

    public void baseTick() {
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        if (!this.isNoGravity()) {
            this.setDeltaMovement(vec3.x, vec3.y - this.getGravity(), vec3.z);
        }
        this.setPos(offX, offY, offZ);
        if (this.level().isClientSide && (this.emitter == null || this.emitter.isRemoved())) {
            ResourceLocation particleId;
            Variant variant = this.getVariant();
            MolangExp expression = MolangExp.EMPTY;
            if (variant == Variant.FROST) {
                particleId = Confluence.asResource("frost_projectile");
            } else if (variant == Variant.SPARK) {
                particleId = Confluence.asResource("spark_projectile");
            } else if (variant == Variant.THUNDER_ZAPPER) {
                particleId = Confluence.asResource("thunder_zapper");
            } else {
                particleId = Confluence.asResource("base_mana_staff_projectile");
                expression = new MolangExp(Map.of("variable.red", Float.toString(variant.color.red()), "variable.green", Float.toString(variant.color.green()), "variable.blue", Float.toString(variant.color.blue())));
            }
            this.emitter = new ParticleEmitter(this.level(), this.position(), particleId, expression);
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        if (this.doPenetrateCheck(entity)) {
            this.doHurtAndKnockback(entity, 0.5, 0.2);
            this.doDiscardInMaxPenetrate(this.penetrateCount);
        }
    }

    @Override
    protected boolean doHurtAndKnockback(Entity target, double knockbackStrength, double knockbackMotionY) {
        float damage = this.getCalculatedDamage() * (1.0f + this.getAttackBonus());
        if (target.hurt(this.getDamageSource(), damage)) {
            float attackKnockback = this.getBaseKnockBack() * (1.0f + this.getKnockbackBonus());
            if (attackKnockback > 0.0f && knockbackStrength > 0.0 || knockbackMotionY > 0.0) {
                VectorUtils.knockBackA2B((Entity)this, (Entity)target, (double)((double)attackKnockback * knockbackStrength), (double)knockbackMotionY);
            }
            this.afterHurtTarget(target);
            return true;
        }
        return false;
    }

    protected void afterHurtTarget(Entity target) {
    }

    protected float getAttackBonus() {
        return 0.0f;
    }

    protected float getKnockbackBonus() {
        return 0.0f;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected double getDefaultGravity() {
        return this.getVariant().gravity;
    }

    protected float getBaseKnockBack() {
        return this.getVariant().knockBack;
    }

    public record Variant(int id, String name, double gravity, float knockBack, FloatRGB color) implements StringRepresentable
    {
        public static final List<Variant> VALUES = new ArrayList<Variant>();
        public static final Variant AMETHYST = Variant.register("amethyst", -1.0, 3.25f, 0.91765f, 0.41961f, 1.0f);
        public static final Variant TOPAZ = Variant.register("topaz", -1.0, 3.5f, 1.0f, 0.81569f, 0.0f);
        public static final Variant SAPPHIRE = Variant.register("sapphire", -1.0, 4.0f, 0.30196f, 0.65098f, 1.0f);
        public static final Variant JADE = Variant.register("jade", -1.0, 4.25f, 0.12941f, 0.72157f, 0.45098f);
        public static final Variant RUBY = Variant.register("ruby", -1.0, 4.75f, 0.92157f, 0.38824f, 0.45882f);
        public static final Variant AMBER = Variant.register("amber", -1.0, 4.75f, 0.98824f, 0.75686f, 0.17647f);
        public static final Variant DIAMOND = Variant.register("diamond", -1.0, 5.5f, 0.60392f, 1.0f, 0.86667f);
        public static final Variant FROST = Variant.register("frost", 0.04, 0.0f, 0.0f, 0.0f, 0.0f);
        public static final Variant SPARK = Variant.register("spark", 0.04, 0.0f, 0.0f, 0.0f, 0.0f);
        public static final Variant THUNDER_ZAPPER = Variant.register("thunder_zapper", -1.0, 0.0f, 0.0f, 0.0f, 0.0f);
        public static final Codec<Variant> CODEC = StringRepresentable.fromValues(() -> VALUES.toArray(new Variant[0])).mapResult((Codec.ResultFunction)new Codec.ResultFunction<Variant>(){

            public <T> DataResult<Pair<Variant, T>> apply(DynamicOps<T> ops, T input, DataResult<Pair<Variant, T>> a) {
                if (a.isError()) {
                    return DataResult.success((Object)new Pair((Object)JADE, input), (Lifecycle)Lifecycle.stable());
                }
                return a;
            }

            public <T> DataResult<T> coApply(DynamicOps<T> ops, Variant input, DataResult<T> t) {
                return t;
            }
        });

        private static Variant register(String name, double gravity, float rawKnockBack, float red, float green, float blue) {
            Variant variant = new Variant(VALUES.size(), name, gravity, rawKnockBack / 8.0f, new FloatRGB(red, green, blue));
            VALUES.add(variant);
            return variant;
        }

        public static Variant byId(int id) {
            return VALUES.get(id);
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

