/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.entity.projectile.mana.RainProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CloudProjectile
extends AbstractManaProjectile
implements GeoEntity {
    protected static final EntityDataAccessor<Integer> DATA_TARGET_ID = SynchedEntityData.defineId(CloudProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected UUID targetUUID;
    protected transient LivingEntity target;
    protected transient double motionY;
    private EntityType<? extends RainProjectile> rainType;
    private int duration;
    private int maxPenetrate;

    public CloudProjectile(EntityType<? extends CloudProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
        this.setNoGravity(true);
    }

    public CloudProjectile(EntityType<? extends CloudProjectile> cloudType, EntityType<? extends RainProjectile> rainType, LivingEntity living, int duration, int maxPenetrate) {
        this(cloudType, living.level());
        this.rainType = rainType;
        this.duration = duration;
        this.maxPenetrate = maxPenetrate;
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder.define(DATA_TARGET_ID, (Object)-114514));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_TARGET_ID.equals(key)) {
            Entity entity;
            if (this.level().isClientSide && (entity = this.level().getEntity(((Integer)this.entityData.get(DATA_TARGET_ID)).intValue())) instanceof LivingEntity) {
                LivingEntity living;
                this.target = living = (LivingEntity)entity;
            }
            if (this.target != null) {
                double d = this.target.distanceTo((Entity)this);
                double h = this.getY() - this.target.getY() - (double)this.target.getBbHeight();
                double v0 = this.getDefaultVelocity();
                double vy = this.getDeltaMovement().y;
                this.motionY = 2.0 * v0 * v0 * (2.0 - h) / (d * d) - 2.0 * vy * v0 / d;
            }
        }
    }

    public void baseTick() {
        if (this.tickCount > 6000 || this.getOwner() == null || this.getOwner().position().distanceToSqr(this.position()) > 4096.0) {
            this.discard();
            return;
        }
        super.baseTick();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3);
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            this.setTarget(null);
            motion = Vec3.ZERO;
        }
        this.setDeltaMovement(motion);
        if (motion.x == 0.0 && motion.y == 0.0 && motion.z == 0.0) {
            LivingEntity owner;
            if (!(this.level().isClientSide || this.duration > 1 && this.level().getGameTime() % (long)this.duration != 0L || (owner = this.getLivingOwner()) == null)) {
                float width = this.getDimensions(this.getPose()).width() * 1.2f;
                RainProjectile entity = new RainProjectile(this.rainType, owner, this.position().add((double)((this.random.nextFloat() - 0.5f) * width), -1.0, (double)((this.random.nextFloat() - 0.5f) * width)));
                entity.setMaxPenetrate(this.maxPenetrate);
                entity.setDamage(this.getDamage());
                this.level().addFreshEntity((Entity)entity);
            }
        } else if (this.getTarget() != null && !this.target.isRemoved()) {
            if (Mth.square((double)(this.getX() - this.target.getX())) + Mth.square((double)(this.getZ() - this.target.getZ())) < 4.0) {
                this.setPos(this.target.position().add(0.0, (double)(this.target.getBbHeight() + 2.0f), 0.0));
                this.setDeltaMovement(Vec3.ZERO);
                this.setTarget(null);
            } else {
                this.setDeltaMovement(motion.add(0.0, this.motionY, 0.0));
            }
        } else {
            this.setTarget(null);
        }
    }

    @Override
    protected void doHitCheck() {
    }

    public void setTarget(@Nullable LivingEntity target) {
        this.target = target;
        if (target == null) {
            this.targetUUID = null;
            this.entityData.set(DATA_TARGET_ID, (Object)-114514);
        } else {
            this.targetUUID = target.getUUID();
            this.entityData.set(DATA_TARGET_ID, (Object)target.getId());
        }
    }

    @Nullable
    public LivingEntity getTarget() {
        ServerLevel level;
        Entity entity;
        Level level2;
        if (this.target == null && this.targetUUID != null && (level2 = this.level()) instanceof ServerLevel && (entity = (level = (ServerLevel)level2).getEntity(this.targetUUID)) instanceof LivingEntity) {
            LivingEntity living;
            this.target = living = (LivingEntity)entity;
        }
        return this.target;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("TargetUUID")) {
            this.targetUUID = compound.getUUID("TargetUUID");
        }
        try {
            ResourceLocation type = ResourceLocation.tryParse((String)compound.getString("RainType"));
            this.rainType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(type);
        }
        catch (Exception ignored) {
            this.rainType = (EntityType)ModEntities.BLOOD_RAIN_PROJECTILE.get();
        }
        this.duration = compound.getInt("Duration");
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.targetUUID != null) {
            compound.putUUID("TargetUUID", this.targetUUID);
        }
        if (this.rainType == null) {
            compound.putString("RainType", "confluence:blood_rain_projectile");
        } else {
            compound.putString("RainType", BuiltInRegistries.ENTITY_TYPE.getKey(this.rainType).toString());
        }
        compound.putInt("Duration", this.duration);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.CACHE;
    }
}

