/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class CrystalStormProjectile
extends AbstractManaProjectile {
    private ParticleEmitter trail;

    public CrystalStormProjectile(EntityType<CrystalStormProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
        this.setNoGravity(true);
    }

    public CrystalStormProjectile(Player player) {
        this((EntityType<CrystalStormProjectile>)((EntityType)ModEntities.CRYSTAL_STORM_PROJECTILE.get()), player.level());
        this.setOwner((Entity)player);
        this.setPos(player.getX(), player.getEyeY() - 0.1, player.getZ());
    }

    @Override
    public void tick() {
        this.setDeltaMovement(this.getDeltaMovement().scale(0.96));
        super.tick();
        if (this.tickCount > 60) {
            this.discard();
        }
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide && (this.trail == null || this.trail.isRemoved())) {
            this.trail = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("crystal_storm_projectile_trail"));
            this.trail.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.trail, false);
        }
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3);
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
        }
        this.setDeltaMovement(motion.scale(0.96));
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        this.doHurtAndKnockback(result.getEntity(), 0.5, 0.2);
        this.discard();
    }
}

