/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class GoldenShowerProjectile
extends AbstractManaProjectile {
    private ParticleEmitter emitter;

    public GoldenShowerProjectile(EntityType<GoldenShowerProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public GoldenShowerProjectile(LivingEntity living) {
        this((EntityType<GoldenShowerProjectile>)((EntityType)ModEntities.GOLDEN_SHOWER_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide && (this.emitter == null || this.emitter.isRemoved())) {
            this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("golden_shower"));
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
        Vec3 vec3 = this.getDeltaMovement();
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        this.setPos(offX, offY, offZ);
        this.setDeltaMovement(vec3.add(0.0, -0.24, 0.0));
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        if (this.level().isClientSide) {
            return;
        }
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (this.doPenetrateCheck(entity)) {
            if (this.doHurtAndKnockback(entity, 3.5, 0.2) && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.addEffect(new MobEffectInstance(ModEffects.ICHOR, 200));
            }
            this.doDiscardInMaxPenetrate(4);
        }
    }
}

