/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.mana;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.mana.AbstractManaProjectile;
import org.confluence.mod.common.init.ModEntities;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class WaterStreamProjectile
extends AbstractManaProjectile {
    private ParticleEmitter emitter;

    public WaterStreamProjectile(EntityType<WaterStreamProjectile> entityType, Level level) {
        super((EntityType<? extends AbstractManaProjectile>)entityType, level);
    }

    public WaterStreamProjectile(LivingEntity living) {
        this((EntityType<WaterStreamProjectile>)((EntityType)ModEntities.WATER_STREAM_PROJECTILE.get()), living.level());
        this.setOwner((Entity)living);
        this.setPos(living.getX(), living.getEyeY() - 0.1, living.getZ());
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide && (this.emitter == null || this.emitter.isRemoved())) {
            this.emitter = new ParticleEmitter(this.level(), this.position(), Confluence.asResource("water_stream"));
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
        Vec3 vec3 = this.getDeltaMovement();
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        this.setPos(offX, offY, offZ);
        this.setDeltaMovement(vec3.add(0.0, -0.24, 0.0));
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (this.doPenetrateCheck(entity)) {
            this.doHurtAndKnockback(entity, 3.5, 0.2);
            this.doDiscardInMaxPenetrate(5);
        }
    }
}

