/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.range.arrow;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.EnchantmentUtil;
import org.confluence.mod.common.item.arrow.BaseTerraArrowItem;
import org.confluence.terraentity.data.component.EffectStrategyComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mesdag.particlestorm.PSGameClient;
import org.mesdag.particlestorm.particle.ParticleEmitter;

public class BaseArrowEntity
extends AbstractArrow {
    protected float minSpeedAttackFactor = 0.5f;
    @Nullable
    Item arrowItem;
    private ParticleEmitter emitter;
    private static final EntityDataAccessor<String> TEXTURE_PATH = SynchedEntityData.defineId(BaseArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> DATA_PARTICLE_ID = SynchedEntityData.defineId(BaseArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> DATA_LUMINANCE = SynchedEntityData.defineId(BaseArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_GRAVITY = SynchedEntityData.defineId(BaseArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public String texturePath = "";
    private int penetrate = 0;
    private final List<LivingEntity> havenBeen = new ArrayList<LivingEntity>();
    @NotNull
    public Builder modify = new Builder();
    private Factory baseArrowFactory;
    public boolean fullPull = false;

    public BaseArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public BaseArrowEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, @Nullable BaseTerraArrowItem arrow) {
        super(entityType, owner, owner.level(), pickupItemStack, firedFromWeapon);
        this.arrowItem = arrow;
        this.baseArrowFactory = arrow == null ? null : arrow.getModifier();
        this.modify = this.baseArrowFactory == null ? new Builder() : this.baseArrowFactory.attr.get();
    }

    public BaseArrowEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, @NotNull BaseTerraArrowItem arrow, BaseTerraArrowItem.ModifyArrowBuilder modifyConsumer) {
        this(entityType, owner, pickupItemStack, firedFromWeapon, arrow);
        if (modifyConsumer != null) {
            modifyConsumer.applyModifiers(this.modify);
        }
        if ((this.modify.type & 4) != 0) {
            this.pickup = AbstractArrow.Pickup.DISALLOWED;
        }
    }

    public BaseArrowEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon, @Nullable BaseTerraArrowItem arrow) {
        super(entityType, x, y, z, level, pickupItemStack, firedFromWeapon);
        this.arrowItem = arrow;
        this.baseArrowFactory = arrow == null ? null : arrow.getModifier();
        this.modify = this.baseArrowFactory == null ? new Builder() : this.baseArrowFactory.attr.get();
    }

    public void modify(Consumer<Builder> consumer) {
        consumer.accept(this.modify);
    }

    public void onAddedToLevel() {
        if ((this.modify.type & 2) != 0) {
            this.setNoGravity(true);
        }
        if (this.baseArrowFactory != null) {
            this.entityData.set(TEXTURE_PATH, (Object)this.baseArrowFactory.path);
            this.texturePath = this.baseArrowFactory.path;
        }
        if (this.modify.particleId != null) {
            this.entityData.set(DATA_PARTICLE_ID, (Object)this.modify.particleId.toString());
        }
        this.entityData.set(DATA_LUMINANCE, (Object)this.modify.luminance);
        this.entityData.set(DATA_GRAVITY, (Object)Float.valueOf(this.modify.gravity));
        super.onAddedToLevel();
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        super.shoot(x, y, z, velocity, inaccuracy);
        this.setDeltaMovement(this.getDeltaMovement().scale((double)(this.modify.speedFactor * (this.level().isRaining() ? this.modify.speedUpInRain : 1.0f))));
    }

    protected float getSpeedDamageFactor(float length) {
        return Math.min(length, 3.0f);
    }

    protected float getSpeedDamageMinFactor(float f) {
        return Math.max(f, this.minSpeedAttackFactor);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.discard();
    }

    protected double getDefaultGravity() {
        return this.modify.gravity;
    }

    protected void onHitEntity(EntityHitResult result) {
        Level var9;
        Entity entity = result.getEntity();
        if (!(entity instanceof LivingEntity)) {
            super.onHitEntity(result);
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (this.havenBeen.contains(living)) {
            return;
        }
        float f = (float)this.getDeltaMovement().length();
        f = this.getSpeedDamageFactor(f);
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)(entity1 != null ? entity1 : this));
        double d0 = this.getBaseDamage();
        if (this.getWeaponItem() != null && (var9 = this.level()) instanceof ServerLevel) {
            int value = EnchantmentUtil.getEnchantmentLevel((ResourceKey)Enchantments.POWER, (ItemStack)this.getWeaponItem());
            d0 *= (double)((float)value * 0.1f + 1.0f);
        }
        f = this.getSpeedDamageMinFactor(f);
        int i = Mth.ceil((double)Mth.clamp((double)((double)f * d0), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long j = this.random.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        float fi = this.level().isRaining() ? this.modify.damageInRain + (float)i : (float)i;
        this.havenBeen.add(living);
        if (entity.hurt(damagesource, fi + this.modify.base_damage)) {
            if ((this.modify.type & 8) != 0) {
                entity.setRemainingFireTicks(this.getRemainingFireTicks() + this.modify.causeFireTick - this.tickCount);
            }
            this.playSound(BaseArrowEntity.getSound(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            this.doPostHurtEffects(living);
            if (!this.level().isClientSide) {
                living.setArrowCount(living.getArrowCount() + 1);
            }
            this.doKnockback(living, damagesource);
            if (this.modify.knockBack > 0.0f) {
                double d1 = this.modify.knockBack;
                Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(0.6 * d1);
                if (vec3.lengthSqr() > 0.0) {
                    living.push(vec3.x, 0.1, vec3.z);
                }
            }
            if (!this.level().isClientSide && entity1 instanceof LivingEntity) {
                EnchantmentHelper.doPostAttackEffects((ServerLevel)((ServerLevel)this.level()), (Entity)entity, (DamageSource)damagesource);
            }
            if (living != entity1 && living instanceof Player && entity1 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity1;
                if (!this.isSilent()) {
                    player.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
            }
            ++this.penetrate;
            if (!this.canPenetrate()) {
                this.discard();
            }
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(-0.1));
            this.setYRot(this.getYRot() + 180.0f);
            this.yRotO += 180.0f;
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7 && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                this.spawnAtLocation(this.getPickupItem(), 0.1f);
            }
        }
    }

    public double getBaseDamage() {
        return super.getBaseDamage();
    }

    protected void doPostHurtEffects(LivingEntity living) {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            this.modify.onHitEffects.forEach(effect -> effect.applyAll(owner, living));
            if (this.fullPull) {
                this.modify.fullPullHitEffects.forEach(effect -> effect.applyAll(owner, living));
            }
        }
        super.doPostHurtEffects(living);
    }

    private static SoundEvent getSound() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    protected ItemStack getDefaultPickupItem() {
        return Items.ARROW.getDefaultInstance();
    }

    public void tick() {
        ResourceLocation location;
        String s;
        if (!this.level().isClientSide && this.tickCount > this.modify.auto_discard_tick) {
            this.discard();
        }
        super.tick();
        if (this.level().isClientSide && this.emitter == null && !(s = (String)this.entityData.get(DATA_PARTICLE_ID)).isEmpty() && (location = ResourceLocation.tryParse((String)s)) != null) {
            this.emitter = new ParticleEmitter(this.level(), this.position(), location);
            this.emitter.attachEntity((Entity)this);
            PSGameClient.LOADER.addEmitter(this.emitter, false);
        }
    }

    public boolean canPenetrate() {
        return this.penetrate + 1 <= this.modify.penetration_count;
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder.define(TEXTURE_PATH, (Object)"").define(DATA_PARTICLE_ID, (Object)"").define(DATA_LUMINANCE, (Object)0).define(DATA_GRAVITY, (Object)Float.valueOf(0.05f)));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (this.level().isClientSide) {
            this.texturePath = (String)this.entityData.get(TEXTURE_PATH);
            this.modify.luminance = (Integer)this.entityData.get(DATA_LUMINANCE);
            this.modify.gravity = ((Float)this.entityData.get(DATA_GRAVITY)).floatValue();
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        if (this.getPickupItemStackOrigin().isEmpty()) {
            if (this.arrowItem != null) {
                this.setPickupItemStack(this.arrowItem.getDefaultInstance());
            } else {
                this.setPickupItemStack(this.getDefaultPickupItem());
            }
        }
        if (this.modify.particleId != null) {
            tag.putString("ParticleId", this.modify.particleId.toString());
        }
        tag.putInt("Luminance", this.modify.luminance);
        tag.putFloat("Gravity", this.modify.gravity);
        super.addAdditionalSaveData(tag);
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && !this.havenBeen.contains(target);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        String string;
        BaseTerraArrowItem arrow;
        super.readAdditionalSaveData(tag);
        Item item = this.getPickupItem().getItem();
        if (item instanceof BaseTerraArrowItem && (arrow = (BaseTerraArrowItem)item).getModifier() != null) {
            this.texturePath = arrow.getModifier().path;
            this.entityData.set(TEXTURE_PATH, (Object)this.texturePath);
        }
        if (!(string = tag.getString("ParticleId")).isEmpty()) {
            this.entityData.set(DATA_PARTICLE_ID, (Object)string);
        }
        this.entityData.set(DATA_LUMINANCE, (Object)tag.getInt("Luminance"));
        this.entityData.set(DATA_GRAVITY, (Object)Float.valueOf(tag.getFloat("Gravity")));
    }

    protected float getWaterInertia() {
        return this.modify.speedUpInWater * super.getWaterInertia();
    }

    public static class Builder {
        private int type = 0;
        public int penetration_count = 0;
        private float gravity = 0.05f;
        private int auto_discard_tick = 1200;
        public float base_damage = 2.0f;
        private float speedFactor = 1.0f;
        private float knockBack = 0.0f;
        private int causeFireTick = 0;
        private int luminance = 0;
        private float speedUpInRain = 1.0f;
        private float speedUpInWater = 1.0f;
        private float damageInRain = 0.0f;
        private BaseTerraArrowItem transformArrow = null;
        public List<EffectStrategyComponent> onHitEffects = new ArrayList<EffectStrategyComponent>();
        public List<EffectStrategyComponent> fullPullHitEffects = new ArrayList<EffectStrategyComponent>();
        @Nullable
        private ResourceLocation particleId;

        public Builder addFullPullHitEffect(EffectStrategyComponent component) {
            this.fullPullHitEffects.add(component);
            return this;
        }

        public Builder addOnHitEffect(EffectStrategyComponent component) {
            this.onHitEffects.add(component);
            return this;
        }

        public Builder setDamage(float damage) {
            this.base_damage = damage;
            return this;
        }

        public Builder setKnockBack(float factor) {
            this.knockBack = factor;
            return this;
        }

        public Builder setSpeedUpInRain(float speedUp) {
            this.speedUpInRain = speedUp;
            return this;
        }

        public Builder setSpeedInertiaInWater(float speedUp) {
            this.speedUpInWater = speedUp;
            return this;
        }

        public Builder setDamageInRain(float damage) {
            this.damageInRain = damage;
            return this;
        }

        public Builder setPenetration(int count) {
            this.type |= 1;
            this.penetration_count = count;
            if (count > 1) {
                this.type |= 4;
                this.auto_discard_tick = Math.min(this.auto_discard_tick, 120);
            }
            return this;
        }

        public Builder setGravity(float gravity) {
            if (gravity == 0.0f) {
                this.type |= 2;
            }
            this.gravity = gravity;
            return this;
        }

        public Builder setAutoDiscard(int tick) {
            this.type |= 4;
            this.auto_discard_tick = tick;
            return this;
        }

        public Builder setSpeedFactor(float factor) {
            this.speedFactor = factor;
            return this;
        }

        public Builder setCauseFire(int tick) {
            this.type |= 8;
            this.causeFireTick = tick;
            this.setLuminance(Math.max(this.luminance, 8));
            return this;
        }

        public Builder setTransformArrow(BaseTerraArrowItem arrow) {
            this.transformArrow = arrow;
            return this;
        }

        public Builder setLuminance(int luminance) {
            this.luminance = luminance;
            return this;
        }

        public Builder setParticleId(ResourceLocation particleId) {
            this.particleId = particleId;
            return this;
        }

        public int getLuminance() {
            return this.luminance;
        }

        public int getType() {
            return this.type;
        }

        @Nullable
        public BaseTerraArrowItem getTransformArrow() {
            return this.transformArrow;
        }
    }

    public static class Factory {
        public String path;
        public Supplier<Builder> attr;

        Factory() {
        }

        public static Factory create(String path, Supplier<Builder> type) {
            Factory t = new Factory();
            t.path = path;
            t.attr = type;
            return t;
        }
    }

    public static class Tag {
        public static final int penetration = 1;
        public static final int no_gravity = 2;
        public static final int auto_discard = 4;
        public static final int cause_fire = 8;
    }
}

