/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.sword;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.sword.SwordProjectile;
import org.confluence.terraentity.api.entity.ITrackType;
import org.confluence.terraentity.registries.track.variant.BasisTrack;
import org.confluence.terraentity.registries.track.variant.SimpleTrack;
import org.confluence.terraentity.utils.TEUtils;

public class BeeKeeperProjectile
extends SwordProjectile {
    private ITrackType trackType;

    public BeeKeeperProjectile(EntityType<? extends SwordProjectile> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.lifetime = 100;
        this.trackType = new BasisTrack(90.0, (double)0.3f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getOwner() != null) {
            if (this.tickCount < 5) {
                this.addDeltaMovement(this.direction);
            } else if (this.tickCount < 10) {
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else {
                LivingEntity target = TEUtils.getAABBAngleTarget((Vec3)this.position(), (Vec3)this.position().add(this.getDeltaMovement().normalize().scale(1.0)), (Level)this.level(), (Entity)this.getOwner(), (double)10.0, (double)180.0, this::canHitEntity);
                if (target != null) {
                    Vec3 dir;
                    Vec3 motion = this.getDeltaMovement();
                    double angle = TEUtils.angleBetween((Vec3)motion, (Vec3)(dir = target.position().add(0.0, (double)(target.getEyeHeight() * 0.5f), 0.0).subtract(this.position())));
                    if (angle < 90.0 && !(this.trackType instanceof SimpleTrack)) {
                        this.trackType = new SimpleTrack(90.0, 0.5, 0.5, Optional.of(0.5), 0.5);
                    }
                    Vec3 movement = this.trackType.calDeltaMovement(this.getDeltaMovement(), dir, angle);
                    this.setDeltaMovement(movement);
                }
            }
        }
    }

    @Override
    protected boolean canHitEntity(Entity target) {
        if (this.tickCount <= 10) {
            return false;
        }
        return target instanceof Enemy && super.canHitEntity(target) && TEUtils.projectileCanHurtEntityTest.test(this, target);
    }

    @Override
    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getOwner() != null) {
            this.direction = new Vec3(Math.sin(Math.random() * (Math.PI * 2)) * (double)0.001f, (double)0.002f * Math.random() + (double)0.004f, Math.cos(Math.random() * (Math.PI * 2)) * (double)0.001f);
            this.entityData.set(DATA_DIRECTION, (Object)this.direction.toVector3f());
        }
        this.knockBack = 0.0f;
        this.baseKnockBack = 0.0f;
    }
}

