/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.entity.projectile.sword;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.projectile.sword.SwordProjectile;
import org.confluence.mod.common.init.ModParticleTypes;

public class LightBaneProjectile
extends SwordProjectile {
    private final List<Entity> hits = new ArrayList<Entity>();

    public LightBaneProjectile(EntityType<LightBaneProjectile> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.hitCount = 99999;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.direction != null) {
            float f = 10.0f;
            float control = Math.min(Math.abs((float)this.tickCount - f), f) * ((float)this.tickCount < f ? -0.02f : 0.02f);
            this.setDeltaMovement(this.direction.normalize().scale((double)control));
            this.lookAt(EntityAnchorArgument.Anchor.EYES, this.getEyePosition().subtract(this.direction));
        }
    }

    @Override
    protected boolean canHitEntity(Entity target) {
        return !this.hits.contains(target) && super.canHitEntity(target);
    }

    @Override
    protected boolean doHurt(Entity target) {
        if (super.doHurt(target)) {
            this.hits.add(target);
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ModParticleTypes.LIGHT_BANE.get(), this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected ParticleOptions getTrailParticle() {
        return this.random.nextBoolean() ? (ParticleOptions)ModParticleTypes.LIGHT_BANE_FADE.get() : (ParticleOptions)ModParticleTypes.LIGHT_BANE_DUST.get();
    }
}

